# The Deep Learning Model[¶](https://knowledge.dataiku.com/latest/courses/advanced-analytics/time-series-code/model.html#the-deep-learning-model "Permalink to this headline")

In a Visual Analysis for the training dataset, create a new model with:

* **Prediction** as the task,

* *target* as the target variable

* **Expert mode** as the prediction style

* **Deep learning** as the Expert mode, then click **Create**

This creates a new machine learning task and opens the Design tab for the task. On the Target panel, verify that Dataiku DSS has correctly identified this as a Regression type of ML task.

## Features Handling with a Custom Processor[¶](https://knowledge.dataiku.com/latest/courses/advanced-analytics/time-series-code/model.html#features-handling-with-a-custom-processor "Permalink to this headline")

On the Features Handling panel, verify that *date* has been rejected as an input. *inputs* should, by default, also be rejected as an input because its values appear to be unique. We need a custom processor that unserializes the input string to a vector, and then normalizes the temperature values to be between 0 and 1.

To create the custom processor, from the top navigation bar go to the Code menu > Libraries. Create a new file called *windowprocessor.py*. The contents of the file should be as follows. It implements the following methods:

* `fit()`, which computes the maximum and minimum values of the dataset

* `transform()`, which normalizes the values to be between 0 and 1

* `\_convert()`, which transforms the data from an array of strings to a 2-dimensional array of floats

§ import numpy as np

§ class windowProcessor:

§ def \_\_init\_\_(self, window\_size):

§ self.window\_size = window\_size

§ def \_convert(self, x):

§ m = np.empty((len(x), self.window\_size))

§ for i in range(len(x)):

§ c = np.array(eval(x[i]))

§ m[i, :] = np.array(eval(x[i]))

§ return m

§ def fit(self, x):

§ m = self.\_convert(x)

§ self.min\_value, self.max\_value = m.min(), m.max()

§ def transform(self, x):

§ m = self.\_convert(x)

§ return (m - self.min\_value) / (self.max\_value - self.min\_value)

Back in the Features Handling panel of the deep learning model, turn on *inputs* as a feature. Select **Text** as the variable type. Select **Custom preprocessing** as the type of text handling. Erase the default code and input the following. This calls the custom processor and tells it that our window has 30 values.

§ from windowprocessor import windowProcessor

§ processor = windowProcessor(30)

This custom features handling creates a new input to the deep learning model called `inputs\_preprocessed`. We’ll use that in the specification of the deep learning architecture.

## Deep Learning Architecture[¶](https://knowledge.dataiku.com/latest/courses/advanced-analytics/time-series-code/model.html#deep-learning-architecture "Permalink to this headline")

We need to import the LSTM and Reshape layers in order to specify our architecture. Replace the first line of code with the following.

§ from keras.layers import Input, Dense, LSTM, Reshape

We now have to create our network architecture in the `build\_model()` function. Delete the default contents of `build\_model()` and insert the following.

§ # This input will receive all the preprocessed features

§ window\_size = 30

§ input\_main = Input(shape=(window\_size,), name="inputs\_preprocessed")

§ x = Reshape((window\_size, 1))(input\_main)

§ x = LSTM(100, return\_sequences=True)(x)

§ x = LSTM(100, return\_sequences=False)(x)

§ predictions = Dense(1)(x)

§ # The 'inputs' parameter of your model must contain the

§ # full list of inputs used in the architecture

§ model = Model(inputs=[input\_main], outputs=predictions)

§ return model

There are three hidden layers. First is a Reshape layer, to convert from a shape of (batch\_size, window\_size) to (batch\_size, window\_size, dimension). Since we only have one input variable at each time step, the dimension is 1. After the reshaping, we can stack 2 layers of LSTM. The output layer is a fully connected layer, Dense, with one output neuron. By default its activation function is linear, which is appropriate for a regression problem.

We’ll make no changes to the compile\_model() function or the Training panel. If you have multiple code environments for deep learning, on the Runtime Environment panel, you should confirm that Dataiku has selected the code environment you want to use with this ML task.
