# Pivot Ranks from Rows into Columns[¶](https://knowledge.dataiku.com/latest/courses/advanced-data-prep/data-pipelines/pivot.html#pivot-ranks-from-rows-into-columns "Permalink to this headline")

Each row in the *orders\_grouped\_windows* dataset will represent a particular year’s spending for a given customer. We eventually want to join this information with other customer information where there is a single row for each customer. Thus, our next step is to Pivot the dataset so that there is a separate column for each year’s customer rankings.

With the empty *orders\_grouped\_windows* dataset selected:

* Choose **Actions > Pivot**.

* Choose *order\_date\_year* as the column to Pivot By.

* Rename the output dataset to something like `orders\_by\_customer\_pivoted`.

* Click **Create Recipe**.

Now we can configure the Pivot recipe.

* Select *customer\_id* as a row identifier.

* Deselect *Count of records* to populate content with.

* Select *rank* from the dropdown list, and choose **min** as the aggregation.

# Run the Recipe(s)[¶](https://knowledge.dataiku.com/latest/courses/advanced-data-prep/data-pipelines/pivot.html#run-the-recipe-s "Permalink to this headline")

Note that, until this point, we have been able to construct a data pipeline without building any datasets because our goal has been clear in each recipe. It wasn’t necessary to see the resulting dataset to move on to the next recipe; all we needed was the schema.

The Pivot recipe, however, poses a problem. We can’t know the schema of the Pivot recipe’s output without running the recipe.

The columns created by the Pivot recipe are dependent upon the range of values of *order\_date\_year*, and so Dataiku cannot create a schema for *orders\_by\_customer\_pivoted* without actually building the dataset.

If we try just running the Pivot recipe, we’ll get an error because the input dataset has not been built yet. (Feel free to try this on your own).

Instead we need to tell Dataiku to also build all of the missing upstream datasets. We could do this from the Flow, but since we’re already in the recipe editor follow these instructions:

* Click on the gear icon next to the **Run** button.

* Select **Build required dependent datasets** as the “Build mode”.

* Click **OK**, and then click **Run**.

Warning

Specifying the recipe to rebuild dependent datasets within the Settings tab of a recipe means that any time it is run, Dataiku will build the upstream datasets. If we don’t want rebuilding to be a permanent setting, we can change it after running the recipe.

Alternatively, we could select the *orders\_by\_customer\_pivoted* dataset from the Flow (outside the recipe editor), and build it recursively.
