# Introducing Dataiku Govern[¶](https://knowledge.dataiku.com/latest/courses/govern/introducing-govern/introducing-dataiku-govern.html#introducing-dataiku-govern "Permalink to this headline")

Now that countless organizations have adopted machine learning in the pursuit of data-driven solutions, it has become clear that machine learning models themselves are not enough to spur desirable business results. In fact, ML models can pose a significant risk to organizations if they are hastily deployed or left unmanaged.

Dataiku provides a governance solution to ensure model quality in a centralized place: the Govern node. Using pre-built and custom assets, some of our governance solutions include:

* Risk-adjusted value monitoring

* AI regulation compliance

* Regulated industries compliance

* Responsible AI

* Positive impact and sustainability

Importantly, users should be able to grow their machine learning projects without compromising control over them. This is why Dataiku Govern lets you track, describe, and monitor your projects at scale in a manageable way.

Let’s start learning how to build governance solutions with Dataiku Govern.

Note

This material is intended for users that will be working on Dataiku Govern. If you are an administrator who needs to set up Dataiku Govern, please look at the product documentation on installing Govern.

## Governance Framework[¶](https://knowledge.dataiku.com/latest/courses/govern/introducing-govern/introducing-dataiku-govern.html#governance-framework "Permalink to this headline")

To better understand Dataiku Govern, you’ll have to understand our governance framework. We developed this framework with two things in mind: scale and control.

Dataiku enables users to scale and control their models in three steps. Each step represents a key principle of model governance.

* **Centralize and Prioritize:** track and organize all of your projects in one place.

* **Explain and Qualify:** define project scope, value, risk, and more.

* **Deploy and Monitor:** review, approve, and monitor models to ensure model quality.

Our framework also dictates which types of items you are able to govern. To govern an item, you must add a governance layer to it. Relatedly, you must delete a governance layer to ungovern an item. You can learn more about this process in later lessons.

Governable items are artifacts in Dataiku to which you can add a governance layer. These items are:

* projects,

* models,

* model versions,

* and bundles.

## What is the Govern node?[¶](https://knowledge.dataiku.com/latest/courses/govern/introducing-govern/introducing-dataiku-govern.html#what-is-the-govern-node "Permalink to this headline")

The Govern node is an additional node in your Dataiku cluster. It interacts with other nodes in the cluster to automatically synchronize items as they evolve.

In Dataiku Govern, you have the option to initiate a validation workflow for your projects, models, model versions, and bundles. This means that for each of these items, you will be able to track your data initiatives, manage workflows, prevent unapproved deployments, and monitor performance over time—–all in one place.
