# Configure Projects for Work with Personal Data[¶](https://knowledge.dataiku.com/latest/courses/governance/gdpr/configure-projects.html#configure-projects-for-work-with-personal-data "Permalink to this headline")

Once a Dataiku DSS instance is configured to work with personal data, you can configure data governance settings at the project level.

While logged in as a user with the *privacy\_admin* group privilege, from the instance homepage, select **+New Project > DSS tutorials > General Topics > Data Governance**.

Note

You can also download the starter project from this website and import it as a zip file.

The video below provides an overview of the features described in the next two sections.

With the GDPR plugin installed, the bottom of any project homepage contains a section of data governance settings. These options include a variety of restrictions a GDPR admin can place on the project.

| GDPR Field | Prevent any user from: |

| --- | --- |

| **Forbid dataset sharing** | Sharing a dataset with personal data outside of the project |

| **Forbid dataset and project export** | Exporting a dataset with personal data, or exporting the project if it contains any dataset with personal data |

| **Forbid model creation** | Creating a model with the Dataiku Visual ML tool on any dataset with personal data |

| **Forbid uploaded datasets** | Creating an “Uploaded files” dataset and potentially introducing personal data to the project in an insecure way. Note that this restriction only affects new datasets, and not existing ones. |

| **Forbidden connections** | Creating a dataset in this project from any of the connections. The idea is that you may want to explicitly restrict the usage of some connections because they contain personal data (CRM source for example). |

For example, here a GDPR admin has forbidden users from sharing or exporting any specific datasets, or the project itself, if they contain personal data. Similarly, users cannot create models based on datasets with personal information.

In practice, if a user who does not belong to the *privacy\_admin* group attempts to edit any of these fields, they will encounter an error like the one below and be unable to save the project.

Warning

The restrictions put in place here encourage best practices, but do not guarantee they will be followed. A user can circumvent the restrictions using code or the API. For a larger context, you may find this white paper available on executing Data Privacy-Compliant Data Projects to help useful.
