# Analyze your data[¶](https://knowledge.dataiku.com/latest/courses/dss-and-nosql/dss-and-mongodb/analyze.html#analyze-your-data "Permalink to this headline")

You are now ready to analyze your MongoDB data. For instance, you could use a visual data preparation script from “Analyze” to flatten or unfold the documents stored in your MongoDB collection:

You may also write the data to MongoDB, for instance if you wished to expose it in a web-based application. Suppose the following dataset has been built:

You could then use a visual preparation script to create a document from each record, using a custom Python formula, for instance:

§ import json

§ def process(row):

§ return {

§ 'actor\_id': row['actor\_id'],

§ 'stats': [

§ {'creation\_count': int(row['creation\_count'])},

§ {'created\_at\_max': str(row['created\_at\_max'])}

§ ]

§ }

Finally, you could write this data to MongoDB by deploying the script, and specifying your MongoDB connection as target:

Wait for your script to run. Your data is written into a new MongoDB collection. You may want to check the output directly from a Mongo shell to be sure it worked:

That’s it for a first taste of integrating DSS and MongoDB.
