# Hands-On Tutorial: Prepare Recipe for Loading a Database[¶](https://knowledge.dataiku.com/latest/courses/dss-and-sql/move-data-to-database/prepare-recipe.html#hands-on-tutorial-prepare-recipe-for-loading-a-database "Permalink to this headline")

Note

This lesson is part of a series of “Usage of SQL and Dataiku tutorials” that begins with the Hands-On Tutorial: Sync Recipe.

Tip

This content is also included in a free Dataiku Academy course Dataiku & SQL, which is an optional part of the Core Designer learning path. Register for the course there if you prefer to track and validate your progress alongside concept videos, text summaries, hands-on tutorials, and quizzes.

The Sync recipe is convenient when you need to copy an existing dataset into a database without any data preparation. In cases when you have some preprocessing to do prior to loading your local data into a database, you can use a Prepare recipe.

* From the Flow, select the *customers\_stacked* dataset.

* Choose **Prepare** from the list of visual recipes in the Actions sidebar.

* Leave *customers\_stacked\_prepared* as the default dataset name.

* Choose to store the new dataset into an available SQL connection.

* Click **Create Recipe**.

Let’s take a few basic preparation steps. See the screencast below for the full details. In summary, we:

* Parse *birthdate*.

* Classify the *user\_agent* column, keeping the resulting *user\_agent\_brand* and *user\_agent\_os* columns.

* Resolve the GeoIP of the *ip\_address* column, keeping the resulting *ip\_address\_country* and *ip\_address\_geopoint* columns.

Click **Run**. The Prepare recipe operations are run in the DSS engine, and the data are then pushed into the PostgreSQL database. The Prepare recipe infers the storage type of each column based on a sample, so typically you don’t have to make any manual adjustments.
