# Concept: Dashboards[¶](https://knowledge.dataiku.com/latest/courses/lab-to-flow/reporting/concept-dashboards.html#concept-dashboards "Permalink to this headline")

Tip

This content is also included in the free Dataiku Academy course, Basics 103, which is part of the Core Designer learning path. Register for the course there if you’d like to track and validate your progress alongside concept videos, summaries, hands-on tutorials, and quizzes.

Once an analytics project is up and running, there is often a strong need to have reporting tools that give project collaborators, as well as external stakeholders, insight into the ongoing performance or results of the project. A dashboard in Dataiku DSS is one of the tools that serve this purpose.

Users can publish elements of a DSS project (such as a table, chart, or model report) to dashboards, and then share these dashboards not only with project collaborators, but a wider group of stakeholders, while still maintaining control over permissions.

Every DSS project has a default dashboard, but an arbitrary number of new dashboards can be created.

* A dashboard is made up of slides.

* Each slide is made up of tiles, which the user can arrange on a grid as needed.

* Each tile on a dashboard slide holds an **insight** from the project.

Many types of insights, such as charts, model reports, Jupyter notebooks, web apps, metrics, and even macros, can be added to dashboards.

Insights generally reference DSS objects. This chart, for example, can be traced back to the source dataset in the Flow.

## Dashboard Permissions and Authorizations[¶](https://knowledge.dataiku.com/latest/courses/lab-to-flow/reporting/concept-dashboards.html#dashboard-permissions-and-authorizations "Permalink to this headline")

In many cases, you will want to have fine control over how a dashboard is created and shared with fellow collaborators, colleagues from separate teams, and other stakeholders. For this, Dataiku DSS provides the option to grant project access to **user groups** or to **individual users**.

When granting project access to user groups, note that the user groups would first have to be created by an admin. The project creator can then share the project with these groups and designate specific permissions of each group with respect to the project at hand. On the other hand, the option to grant project access to individual users eliminates the need for users to first belong to specific groups, making this option useful for a non-admin.

The reference documentation provides a full accounting of all possible permissions, but here we’ll show a few examples of how the permission model based on user groups can be put to work as it relates to dashboards.

## Project builders[¶](https://knowledge.dataiku.com/latest/courses/lab-to-flow/reporting/concept-dashboards.html#project-builders "Permalink to this headline")

As shown in the figure below, fellow project collaborators may be members in a group, such as *data\_team*, and have a wide range of permissions including the ability to “Write project content”. This implies the permissions to read, write, and moderate dashboards.

Note

Also notice the button for granting access to individuals in the figure below.

## Dashboard builders[¶](https://knowledge.dataiku.com/latest/courses/lab-to-flow/reporting/concept-dashboards.html#dashboard-builders "Permalink to this headline")

Also shown above, another group of users, perhaps called the *viz\_team*, may be responsible for creating dashboards once the data team is finished building the project Flow.

It might be reasonable to grant users in this group the ability to moderate dashboards, which implies the permission to read and write dashboards, and the permissions to manage dashboard permissions and dashboard users. They may also require the ability to read, but not write project content.

With the set of permissions above, users in the *viz\_team* group can create new dashboards or they can add new slides and tiles to an existing dashboard from DSS objects.

When adding new insights, DSS issues warnings when new objects are added to the dashboard that have not previously been shared with dashboard-only users.

When the dashboard is ready to be discovered by more users, the project owner, an admin, or a user with the “Moderate dashboards” permission can switch a dashboard from the default private to a public setting. This allows those with the correct permissions to find the dashboard on their DSS homepages.

## Dashboard readers[¶](https://knowledge.dataiku.com/latest/courses/lab-to-flow/reporting/concept-dashboards.html#dashboard-readers "Permalink to this headline")

Finally, you may also have users who should only be able to access a completed dashboard, but not modify its contents in any way.

Although an admin could assign this restricted level of permission to any group, a user with the permission to “Moderate dashboards” can also grant dashboard access to specific users on the instance.

A dashboard-only user cannot create a new project. They cannot see the project Flow. They can view but not edit, copy, or delete the dashboard. They cannot inspect the source objects behind any insight.

## Exporting Dashboards[¶](https://knowledge.dataiku.com/latest/courses/lab-to-flow/reporting/concept-dashboards.html#exporting-dashboards "Permalink to this headline")

This gives an introduction to the many ways in which you can share dashboard access with DSS users, but often you may need to share a dashboard, or pieces within it, externally, outside of DSS.

For this, you can export a dashboard as a PDF or PNG file. Not only can you do this manually through the interface, but also automatically through a scenario so that exports arrive by mail or are stored in a managed folder.
