# Concept: The Difference Between Webapps and Dataiku Applications[¶](https://knowledge.dataiku.com/latest/kb/o16n/dataiku-applications/webapps-vs-dataiku-applications.html#concept-the-difference-between-webapps-and-dataiku-applications "Permalink to this headline")

Their names and use cases might be similar, but Dataiku applications and webapps are different and have different purposes in Dataiku.

* In summary:: * Webapps are great for developers who want to create custom or interactive visualizations.
* Dataiku applications are ideally suited for business teams who need to create and share business applications with many users across an organization.

Let’s look at each of these in more detail.

## Webapps[¶](https://knowledge.dataiku.com/latest/kb/o16n/dataiku-applications/webapps-vs-dataiku-applications.html#webapps "Permalink to this headline")

A developer uses code to build a webapp so that it can be consumed by other Dataiku users. One common use of webapps is to create advanced visualizations or custom applicative frontends.

The following example demonstrates a webapp in Dataiku:

A webapp can be written in many different programming languages:

* Standard (written in HTML/CSS/JS, and optionally with a Python backend),

* R (using the Shiny library),

* Python (using the Bokeh or Dash libraries).

Knowledge of at least one of these technologies is required to create a webapp. While webapps offer flexibility, the developer has to write their own frontend and backend.

The following example demonstrates the creation of a webapp using Bokeh:

Developers create webapps within a Dataiku project. Any user with the correct permissions can access the webapp. Developers can also share their webapps with non-Dataiku users.

While Dataiku does not automatically allow concurrent usage of a webapp, the developer can implement code to allow more than one user to access the same webapp at the same time.

## Dataiku Applications[¶](https://knowledge.dataiku.com/latest/kb/o16n/dataiku-applications/webapps-vs-dataiku-applications.html#dataiku-applications "Permalink to this headline")

A Dataiku application is a project that has been packaged by a Dataiku designer as a visual application. For example, this sales forecasting application started out as a project. It was packaged by the designer of the project to allow users to build their own sales history dashboards by entering information into a custom field:

The purpose of a Dataiku application is to package a Dataiku project and share it with other users, such as business analysts, so they can complete specific tasks without having to run the recipes in the project itself.

While coding skills are not required, application designers may need strong knowledge of Dataiku. The application designer simply accesses the Application Designer from their project in Dataiku when they want to create a Dataiku application:

Let’s say a data-driven marketing team relies on a single data scientist to build dashboards for monitoring performance by region and quarter. The data scientist receives multiple requests each day for up-to-date data using different input parameters.

Instead of manually resolving each request individually, the data scientist can package her project into an easy-to-use Dataiku application, so the members of the marketing team can choose the parameters they want and in a few seconds, get the insights for their business needs.

Each application contains a description at minimum. The designer of the application can include input fields, such as a method for a user to input a dataset, action buttons, and results such as dashboards, output datasets, or file and folder downloads. Since the designer of the application can package any Dataiku project, the application can execute code recipes, train models, and execute remote connections such as Kubernetes.

In addition, Dataiku allows multiple users to run a Dataiku application at the same time using different data or parameters. Dataiku users can find applications on the home page in a dedicated Applications section or access them from the Applications menu. To manage access, the application designer can configure the execute permissions for the application.

Finally, an application designer can package their application in a recipe so that it can be executed externally via the public REST API.

## What’s Next?[¶](https://knowledge.dataiku.com/latest/kb/o16n/dataiku-applications/webapps-vs-dataiku-applications.html#what-s-next "Permalink to this headline")

For more information, visit the Dataiku Webapps and Dataiku Applications product documentation.

For an interactive learning experience, try the Academy tutorial on Dataiku apps or the course on Visualization, which includes webapps.
