# In Visual ML, why am I getting the error “All values of the target are equal” when they are not?[¶](https://knowledge.dataiku.com/latest/kb/analytics-ml/In-Visual-ML-why-am-I-getting-the-error-All-values-of-the-target.html#in-visual-ml-why-am-i-getting-the-error-all-values-of-the-target-are-equal-when-they-are-not "Permalink to this headline")

This error “All values of the target are equal” means that the target column you’re choosing to predict is a constant.

If you know that there is more than one target value in your full dataset, then it’s likely that the current sample is causing the issue by returning all the same values for the target column. This could be because of the way the data is sorted since the default sampling method for the Train/Test set is to take the first N records of your dataset.

Fortunately, the sampling method is easily configured. To workaround the issue at hand, you can try using **random sampling** instead, which you can specify in the Train / Test Set tab within the model design in the Lab.

Note that this will take a longer time because DSS must read the entire input dataset to compute a sample, which will cache. This sample should then have several different values in the target column.

If the issue persists, then you may want to review your workflow and dataset to check if the column you chose as a target does indeed contain the values that you expect.

## What’s next?[¶](https://knowledge.dataiku.com/latest/kb/analytics-ml/In-Visual-ML-why-am-I-getting-the-error-All-values-of-the-target.html#whats-next "Permalink to this headline")

Many parts of Dataiku DSS support sampling data to extract subsets and/or reduce the size of data to process. Sampling can be useful for data exploration, charts, visual data preparation, and machine learning.

Visit our documentation pages to learn more about sampling methods in Dataiku DSS overall, or specifically in-memory sampling in Explore.
