# Delivery Dock Optimization[¶](https://knowledge.dataiku.com/latest/kb/business-solutions/delivery-dock-optim/delivery-dock-optim.html#delivery-dock-optimization "Permalink to this headline")

Contents

* Overview

+ Business Case

+ Technical Requirements

+ Installation

+ Data Requirement

+ Project Overview

* Walkthrough

+ Ingesting and Preparing our Data

+ Visual Exploration and Optimization

+ Under the Hood: Understanding Results

+ Reproducing these Processes With Minimal Effort For Your Own Data

## Overview[¶](https://knowledge.dataiku.com/latest/kb/business-solutions/delivery-dock-optim/delivery-dock-optim.html#overview "Permalink to this headline")

### Business Case[¶](https://knowledge.dataiku.com/latest/kb/business-solutions/delivery-dock-optim/delivery-dock-optim.html#business-case "Permalink to this headline")

Imagine a large warehouse facility. Trucks are constantly arriving and leaving. Often they show up late or require a specific dock that is being used by someone else. Miscommunication might mean they show up at the wrong time… Managing slots in these facilities is not easy. There are just so many moving parts and constantly evolving factors. Throw in third-party carriers contracted by shippers for ad-hoc pick-ups, which gets more complicated.

Delivery dock optimization is, therefore, a vital touchpoint for warehouses, carriers, shippers, and suppliers. Across studies done between 2020 and 2021, truck drivers report a surge in average waiting time to access delivery docks, often exceeding the two-hour mark. This in turn leads to an increase in costs, and impact on goods quality - not to mention people retention issues as drivers are becoming an increasingly scarce resource. Acting upon dock delivery management becomes a critical source of competitive advantage for all companies dependent on fret management.

With this solution, warehouse managers and production planners can quickly integrate data from their truck providers to deliver a comprehensive and extensive view over the planned schedule, analyze performance, run scenarios, and optimize the slots of docks by reallocating slots to adapt to potential delays. Eased integration with Shippeo allows near-real time and more accelerated optimization, paving the way for more resilient management of the supply chain & logistics.

### Technical Requirements[¶](https://knowledge.dataiku.com/latest/kb/business-solutions/delivery-dock-optim/delivery-dock-optim.html#technical-requirements "Permalink to this headline")

To leverage this solution, you must meet the following requirements:

* Have access to a DSS 11.0+ instance.

* A Python 3.6 code environment named `solution\_delivery-dock-optimization` and the following required packages:

§ pulp

§ openpyxl

§ plotly

§ flask

§ nbformat>=4.2.0

Note

When creating a new code environment, please be sure to use the name `solution\_delivery\_dock\_optimization` or remapping will be required.

### Installation[¶](https://knowledge.dataiku.com/latest/kb/business-solutions/delivery-dock-optim/delivery-dock-optim.html#installation "Permalink to this headline")

For the moment, this solution is in a soft-release Beta phase. If you are interested in downloading and/or testing the solution, please contact your Dataiku account manager or use the general Contact Us form.

### Data Requirement[¶](https://knowledge.dataiku.com/latest/kb/business-solutions/delivery-dock-optim/delivery-dock-optim.html#data-requirement "Permalink to this headline")

This solution was built with the following datasets:

* **Truck Tracking Data**: It comes from an external software that provides the Estimated Time of Arrival of the trucks to a given warehouse. It is the backbone of the solution.

* **Warehouse Data:** It is composed of 2 input datasets.

+ The input compatibility dataset contains the docks compatibilities and associated weights.

+ The input weights contains, for each compatibility, a waiting penalty weight that is used in the optimization.

* **Correspondence Data:** It is composed of 3 input datasets.

+ The products shipments correspondence contains the shipment IDs and the associated type of product, it’s used to link shipments to docks.

+ The trucks ID correspondence contains the truck’s IDs from the trucks tracking software and a meaningful name for end users.

+ The warehouse correspondence contains the warehouse IDs trucks tracking software and a meaningful name for end users.

This project is meant to be used as a template to guide the development of your own analysis in DSS. The data provided with the project may not be representative of actual data in a real-life project.

### Project Overview[¶](https://knowledge.dataiku.com/latest/kb/business-solutions/delivery-dock-optim/delivery-dock-optim.html#project-overview "Permalink to this headline")

Note

In-depth technical details can be found in the wiki of the project.

The project consists in the following steps:

Ingest the input data in the Dataiku Application

Play with dock’s slots availabilities in the project’s Webapp

Understand the optimizations in the Dashboard with visualisations

Run scenarios to enter your constraints and optimize your warehouse’s efficiency

## Walkthrough[¶](https://knowledge.dataiku.com/latest/kb/business-solutions/delivery-dock-optim/delivery-dock-optim.html#walkthrough "Permalink to this headline")

You can follow along with the solution in the Dataiku gallery.

### Ingesting and Preparing our Data[¶](https://knowledge.dataiku.com/latest/kb/business-solutions/delivery-dock-optim/delivery-dock-optim.html#ingesting-and-preparing-our-data "Permalink to this headline")

The project’s flow zone is organized into four different categories:

The Blue zones are the input data.

The Yellow ones are the data preparation.

The Green zone is the optimization.

The Dark Blue zones represent the visualizations.

The starting point of this solution is the Dataiku Application. It is used to set up the project and change the input constraints, edit the study parameters and visualize the results of the optimization. The first touchpoint is to insert the warehouse’s name and day of observation in the Study Parameters which will enable you to play with the Webapp. After this, you can edit the first section allowing you to change editable datasets for dock compatibility and optimization weights, while the second section allows you to change input datasets.

We’re now ready to move on to the Webapp setup which can be reached by clicking the “Input Slots Selection” button.

### Visual Exploration and Optimization[¶](https://knowledge.dataiku.com/latest/kb/business-solutions/delivery-dock-optim/delivery-dock-optim.html#visual-exploration-and-optimization "Permalink to this headline")

The second touchpoint of this solution is the setting up of the Webapp. Designed for the user, you can easily understand the dock’s availabilities by keeping the scheduled ones, changing the slots according to incoming events and data, and even opening a closed dock to optimize the warehouse’s operations. Once the changes are made, the dataset used as input for the optimization solver is updated.

Then, the user needs to click **Submit Slots** before going back to the Dataiku App in order to **Optimize** before moving along to the visualizations of the dashboard (which can be reached by clicking **Warehouse Activities** in the App).

### Under the Hood: Understanding Results[¶](https://knowledge.dataiku.com/latest/kb/business-solutions/delivery-dock-optim/delivery-dock-optim.html#under-the-hood-understanding-results "Permalink to this headline")

As the webapp allows the user to play around with slot’s availability, an understanding of the repercussions of those changes is mandatory. Hence, the visualizations in the Dashboard are updating the user with metrics and the different effects the optimization had on the warehouse’s efficiency.

A reminder that the information in the dashboard is about the related warehouse and specified day mentioned in the first steps of the Dataiku Application.

The first tab gives the main KPIs from the trucks tracking system and a summary of the activities of the warehouse on that specified day of observation. It is composed of four graphs:

* The first two demonstrate the expected trucks per slot and the predicted delay associated.

* The third one is showing the selected slots within the Webapp.

* The fourth and last one shows the number of available docks and when the trucks are supposed to arrive. It clearly demonstrates the overbooking of slots leading to a waiting time for trucks/drivers when docks are overbooked.

As for the second tab of the Dashboard, it runs the scenario that rebuilds the flow and runs the optimization.

The first metric shown has to be **“Optimal”** for the optimization to be efficient. The following graphs also portray the optimization. There is the availability of docks with a before/after optimization comparison, reallocation charts per dock, and a comparison of different types of ETAs before/after optimization.

### Reproducing these Processes With Minimal Effort For Your Own Data[¶](https://knowledge.dataiku.com/latest/kb/business-solutions/delivery-dock-optim/delivery-dock-optim.html#reproducing-these-processes-with-minimal-effort-for-your-own-data "Permalink to this headline")

The intent of this project is to enable a warehouse manager or a supply chain analyst to understand how Dataiku can be used to leverage tracking data of trucks to manage warehouses’ docks and optimize efficiency. By creating a singular solution that can benefit and influence the decisions of a variety of teams in a single organization, or across multiple organizations, reducing waiting-time costs and bottlenecks in the shipments and trucks’ arrivals/departures of the warehouse.

We’ve provided several suggestions on how to use tracking data, warehouse data, and correspondence data to optimize warehouse efficiency but ultimately the “best” approach will depend on your specific needs and data. If you’re interested in getting near real-time optimization, the leveraging of Shippeo speeds data integration from all your truck logistics providers in the solution. To adapt this project to the specific goals and needs of your organization, roll-out and customization services can be offered on demand.
