# How to Create a Custom Webapp[¶](https://knowledge.dataiku.com/latest/kb/customization/plugins/examples/webapp.html#how-to-create-a-custom-webapp "Permalink to this headline")

In this tutorial, we’ll start from the webapp created in the Bokeh webapp tutorial.

## Convert to a Webapp Plugin[¶](https://knowledge.dataiku.com/latest/kb/customization/plugins/examples/webapp.html#convert-to-a-webapp-plugin "Permalink to this headline")

* Click the **Actions** button of the webapp you created to open the right panel.

* Click **Plugin** to convert it to a plugin webapp.

* Choose your existing dev plugin as the target plugin.

* Give the webapp an identifier like `custom-scatterplot`.

* Click **Convert**.

* Confirm the overwrite of existing sources, if necessary, and choose to edit the plugin now.

### Edit Definitions in webapp.json[¶](https://knowledge.dataiku.com/latest/kb/customization/plugins/examples/webapp.html#edit-definitions-in-webapp-json "Permalink to this headline")

First, let’s have a look at the *webapp.json* file. This describes the parameters that the user will have to specify when using the plugin webapp.

Note that unlike the *recipe.json* file of a plugin recipe (see that lesson), there are no `input\_roles` or `output\_roles` sections of JSON, and we can focus on editing the `params` section.

Thinking about the parameters to specify, there’s:

* the input dataset

* the X-axis column

* the Y-axis column

* the “time” column

* a categorical column

... which can be specified in the JSON as follows.

§ "params": [

§ {

§ "name": "input\_dataset",

§ "type": "DATASET",

§ "label": "Dataset",

§ "description": "The dataset used to populate the webapp",

§ "mandatory": true,

§ "canSelectForeign": true

§ },

§ {

§ "name": "x\_column",

§ "type": "DATASET\_COLUMN",

§ "datasetParamName": "input\_dataset",

§ "label": "X-Axis Column",

§ "description": "",

§ "mandatory": true

§ },

§ {

§ "name": "y\_column",

§ "type": "DATASET\_COLUMN",

§ "datasetParamName": "input\_dataset",

§ "label": "Y-Axis Column",

§ "description": "",

§ "mandatory": true

§ },

§ {

§ "name": "time\_column",

§ "type": "DATASET\_COLUMN",

§ "datasetParamName": "input\_dataset",

§ "label": "Time Column",

§ "description": "",

§ "mandatory": true

§ },

§ {

§ "name": "cat\_column",

§ "type": "DATASET\_COLUMN",

§ "datasetParamName": "input\_dataset",

§ "label": "Categorical Column",

§ "description": "",

§ "mandatory": true

§ }

§ ],

After doing that, uncomment the roles section.

§ "roles": [

§ {"type": "DATASET", "targetParamsKey": "input\_dataset"}

§ ]

### Edit code in backend.py[¶](https://knowledge.dataiku.com/latest/kb/customization/plugins/examples/webapp.html#edit-code-in-backend-py "Permalink to this headline")

Now let’s edit *backend.py*. The default contents include the code from your Python Bokeh webapp. Looking through the code, we can see that the original webapp is written in such a way that we can easily generalize it.

Find the block that begins with the comment `Parameterize webapp inputs` and replace it with what follows:

§ # Retrieve parameter values from the of map of parameters

§ input\_dataset = get\_webapp\_config()['input\_dataset']

§ x\_column = get\_webapp\_config()['x\_column']

§ y\_column = get\_webapp\_config()['y\_column']

§ time\_column = get\_webapp\_config()['time\_column']

§ cat\_column = get\_webapp\_config()['cat\_column']

Next we’ll access the input Dataiku dataset as a pandas dataframe, and extract the X- and Y-axis columns from the pandas dataframe to define the source data for the visualization.

## Use Your Custom Webapp in a Project[¶](https://knowledge.dataiku.com/latest/kb/customization/plugins/examples/webapp.html#use-your-custom-webapp-in-a-project "Permalink to this headline")

Note

After editing *webapp.json* for a plugin webapp, you must do the following:

* Click **Reload**.

* Reload the Dataiku DSS page in your browser.

When modifying the *backend.py* file, you don’t need to reload anything. Simply restart the webapp backend.

* Go to the Flow and open a dataset, such as *Orders\_enriched\_prepared*.

* From the **Actions** sidebar, select your plugin webapp.

* Give the new webapp a name (or accept the default).

* In the Settings tab, make the desired selections for displaying the webapp.

* Click **Save and view webapp**.

The webapp displays with the selected settings, and provides the interactivity to change the plot title, the time period to display, and the category of the categorical column.

In order to change the dataset and columns used by the webapp, go to the **Settings** tab, make the new selections, and click **View webapp**.
