# Examples of Plugin Component Development[¶](https://knowledge.dataiku.com/latest/kb/customization/plugins/examples/index.html#examples-of-plugin-component-development "Permalink to this headline")

Dataiku’s integration of code allows you to accomplish anything within the platform through custom code. Plugins allow you to extend the Dataiku GUI by sharing your custom code in various ways.

You can install existing plugins from the store, by uploading a Zip file, or from a Git repository.

In this course, you will learn how to write your own *dev* plugins

## Prerequisites[¶](https://knowledge.dataiku.com/latest/kb/customization/plugins/examples/index.html#prerequisites "Permalink to this headline")

* Developing plugins requires that you have a good working knowledge of Python and/or R.

## Technical Requirements[¶](https://knowledge.dataiku.com/latest/kb/customization/plugins/examples/index.html#technical-requirements "Permalink to this headline")

* You must belong to a group that has the Develop Plugins permission.

## Create a Dev Plugin[¶](https://knowledge.dataiku.com/latest/kb/customization/plugins/examples/index.html#create-a-dev-plugin "Permalink to this headline")

Before starting any of the tutorials, you’ll need a new dev plugin. You can create a new plugin for each tutorial, or use the same plugin for all of them. To create a *dev* plugin:

* From the application menu, choose **Plugins**, then click **Development**.

* Click **Add Plugin**, then choose **Write your own**.

* In **New plugin**, type an identifier for your plugin, such as `first-plugin`.

* Click **Create**.

The identifier should be globally unique. Prefixing plugin id’s with your company name, or something similar, will help prevent conflicting names if you import plugins from 3rd party sources.

Now that we have a skeleton for a plugin, we can add some **components** to it.

## Plugin components[¶](https://knowledge.dataiku.com/latest/kb/customization/plugins/examples/index.html#plugin-components "Permalink to this headline")

A plugin is made of a number of **components**. Each component is a single kind of object in Dataiku DSS, such as a dataset, recipe, or webapp.

The following lessons walk through development of different types of components. Each component can be added to the dev plugin you created above, or into their own new plugins.

## Articles[¶](https://knowledge.dataiku.com/latest/kb/customization/plugins/examples/index.html#articles "Permalink to this headline")

* How to Create a Custom Recipe

* How to Create a Custom Dataset

* How to Create a Partitioned Custom Dataset

* How to Create a Custom Webapp

* How to Create a Custom Machine Learning Algorithm
