# Setting Up Your Code Editor to Develop Dataiku Plugins[¶](https://knowledge.dataiku.com/latest/kb/customization/plugins/outside-dss.html#setting-up-your-code-editor-to-develop-dataiku-plugins "Permalink to this headline")

Though the Dataiku interface has a built-in code editor, you may have a preferred IDE. You can set up your IDE for interactive editing of your plugin code.

This enables you to develop plugins in your favorite coding environment. You will also be able to test that your plugin is working as expected by interacting with DSS through its APIs.

## Prerequisites[¶](https://knowledge.dataiku.com/latest/kb/customization/plugins/outside-dss.html#prerequisites "Permalink to this headline")

* This guide covers setup with *Atom* and *Sublime Text 3*

* This guide covers only interactive `python` execution

Note

All steps in this tutorial happen outside of Dataiku DSS.

## Installing Packages[¶](https://knowledge.dataiku.com/latest/kb/customization/plugins/outside-dss.html#installing-packages "Permalink to this headline")

You must start by setting up a virtual environment in your workspace. In Python 3 you can use `python3 -m venv dataiku\_dev\_env`.

Activate your environment by running `source dataiku\_dev\_env/bin/activate`.

To install the `dataikuapi` package you can run `pip install dataiku-api-client`.

You must now install the `dataiku` package, please follow the instructions on our page dedicated to the installation of this package.

## Set Up the Kernels[¶](https://knowledge.dataiku.com/latest/kb/customization/plugins/outside-dss.html#set-up-the-kernels "Permalink to this headline")

We will now take care of the interactive environment. Run `pip install ipykernel` to install Jupyter.

You need to create a kernel specification in your user space so that your IDE can find it later. `python -m ipykernel install --user --name dataiku --display-name "Python (Dataiku venv)"`

## Set up your code editor[¶](https://knowledge.dataiku.com/latest/kb/customization/plugins/outside-dss.html#set-up-your-code-editor "Permalink to this headline")

### In Atom[¶](https://knowledge.dataiku.com/latest/kb/customization/plugins/outside-dss.html#in-atom "Permalink to this headline")

Install the package Hydrogen by going to Settings (ctrl+,) -> + Install.

You can now open any Python source file and use shift+enter. This will start a kernel in the current file.

### In Sublime Text 3[¶](https://knowledge.dataiku.com/latest/kb/customization/plugins/outside-dss.html#in-sublime-text-3 "Permalink to this headline")

Install the package Hermes (use ctrl+shift+p to open Package Control).

When you start a Hermes kernel, an output tab will appear. It is recommended to split your view in two panes and have that tab in the right pane.

Open your Python source file in the left pane and add `# %%` to define your cells. A “Run cell” phantom button will appear next to them!

## Developing a plugin[¶](https://knowledge.dataiku.com/latest/kb/customization/plugins/outside-dss.html#developing-a-plugin "Permalink to this headline")

### File structure[¶](https://knowledge.dataiku.com/latest/kb/customization/plugins/outside-dss.html#file-structure "Permalink to this headline")

Within plugins, it is recommended to develop libraries that will provide the core functionality you are looking to add. Additionally, you should provide some recipes that use your libraries.

When developing locally you can use a test file to check that your library is working as expected. Here is a typical file structure:

§ custom-recipes/my-recipe        Recipe folder

§ recipe.json                   Recipe definition

§ recipe.py                     Recipe contents, runs within DSS

§ python-lib                      Library folder

§ mylib.py                      Library contents

§ README.md

§ plugin.json

§ test.py                         A local file to test your library
