# Dataiku APIs[¶](https://knowledge.dataiku.com/latest/kb/code/apis.html#dataiku-apis "Permalink to this headline")

Tip

To validate your knowledge of this area, register for the APIs in Dataiku DSS course, part of the Developer learning path, on the Dataiku Academy.

## Working Within Dataiku (Basics)[¶](https://knowledge.dataiku.com/latest/kb/code/apis.html#working-within-dataiku-basics "Permalink to this headline")

**Python API.** Using the internal Python API, one can read a Dataiku DSS dataset into a dataframe, process the dataframe with Python code, and then write back to a Dataiku DSS dataset. Examples include:

* Reading a Dataiku DSS dataset to create a Bokeh web app,

* How to execute an SQL query from a Python recipe to read a Dataiku DSS dataset into a dataframe

**R API.** Using the internal R API, one can read a Dataiku DSS dataset into a dataframe, process the dataframe with R code, and then write back to a Dataiku DSS dataset. Examples include:

* Reading a Dataiku dataset to create a Shiny web app

* Reading a Dataiku dataset to create an RMarkdown report

**Javascript API.** Using the internal Javascript API, one can read a Dataiku DSS dataset into a dataframe. Examples include:

* Reading a Dataiku dataset to create a Javascript/CSS web app

## Automating Your Work in Dataiku[¶](https://knowledge.dataiku.com/latest/kb/code/apis.html#automating-your-work-in-dataiku "Permalink to this headline")

**Custom scenarios.** One can create custom scenarios using the internal Python API.

**Scoring Services.** An Application Developer can query scoring services on the Dataiku API node.

**Bundle and Service Package Deployment.** Using the Public API, a Production Environment Manager can:

* Download project bundles from a Design node,

* Upload them to and manage them on an Automation node, and

* Transfer API service packages from an Automation node to an API node.

## Administering Dataiku Remotely[¶](https://knowledge.dataiku.com/latest/kb/code/apis.html#administering-dataiku-remotely "Permalink to this headline")

Using the Public API, an administrator can:

* Manage security settings, such as creating users, groups, and projects, on a Dataiku DSS instance

* Manage connections from Dataiku to various data stores

* Populate a project with datasets, recipes, and models according to preset configurations

In this way, you can spin up and take down Dataiku instances as they are needed on cloud infrastructures.

## More Articles[¶](https://knowledge.dataiku.com/latest/kb/code/apis.html#more-articles "Permalink to this headline")

* Concept: APIs in Dataiku

* Concept: The dataiku Package

* Concept: The Public API

* Hands-On Tutorial: The Public API in Dataiku

* Concept: APIs Outside Dataiku
