# How to add a group to a Dataiku DSS Project using a Python Script[¶](https://knowledge.dataiku.com/latest/kb/code/python/How-to-add-a-group-to-a-DSS-Project-using-a-Python-Script.html#how-to-add-a-group-to-a-dataiku-dss-project-using-a-python-script "Permalink to this headline")

You can add a group to a Dataiku DSS Project, and add the ldap authorization group, in Python.

## Using a Python Script[¶](https://knowledge.dataiku.com/latest/kb/code/python/How-to-add-a-group-to-a-DSS-Project-using-a-Python-Script.html#using-a-python-script "Permalink to this headline")

Here is a sample code snippet to achieve this:

§ import dataiku

§ client = dataiku.api\_client()

§ client.create\_project(name="SAMPLE\_PROJECT", project\_key="SAMPLE\_PROJECT", owner="YOUR\_USER")

§ project = client.get\_project("SAMPLE\_PROJECT")

§ project\_permissions = project.get\_permissions()

§ project\_permissions['permissions'].append({'group':'data\_scientists','readProjectContent': True, 'readDashboards': True})

§ project.set\_permissions(project\_permissions)

Please note for this snippet, there are two assumptions:

* There is a user called `YOUR\_USER` so replace that with a user that actually exists on your instance.

* There is a group called `data\_scientists`.

## In an Automation Node[¶](https://knowledge.dataiku.com/latest/kb/code/python/How-to-add-a-group-to-a-DSS-Project-using-a-Python-Script.html#in-an-automation-node "Permalink to this headline")

After activating the project in an Automation node, you can edit permissions and give access to the relevant groups.

### Specifying which datasets should be included in a Project Bundle[¶](https://knowledge.dataiku.com/latest/kb/code/python/How-to-add-a-group-to-a-DSS-Project-using-a-Python-Script.html#specifying-which-datasets-should-be-included-in-a-project-bundle "Permalink to this headline")

The bundle you create will do so using the project settings. Therefore, before you create it, modify the settings of the project. Depending on whether you use the Python or HTTP rest API, the section to modify is:

§ project\_settings['bundleExporterSettings']['exportOptions']

In order to get there, instantiate the project and modify the settings (obtain settings, then edit the relevant part), see this section of the reference documentation for an example.

Regarding the exact shape of what you need to enter, you may find it easier to create through the UI, and then inspect the resulting settings of the project in the API. That way, you can modify it programmatically later.

## Next Steps[¶](https://knowledge.dataiku.com/latest/kb/code/python/How-to-add-a-group-to-a-DSS-Project-using-a-Python-Script.html#next-steps "Permalink to this headline")

For further information about utilizing the Python APIs, please refer to the following documents:

* User and groups

* Modifying project settings
