# Using Wikis to Share Knowledge[¶](https://knowledge.dataiku.com/latest/kb/collaboration/wiki.html#using-wikis-to-share-knowledge "Permalink to this headline")

Wikis are a widely-used tool for collaboration, allowing team members to create and edit articles that document a project, a group of projects, or more.

## Create Your First Article[¶](https://knowledge.dataiku.com/latest/kb/collaboration/wiki.html#create-your-first-article "Permalink to this headline")

Every project in Dataiku DSS is wiki-enabled. To create your first article:

* Go to the Wiki section of the navigation bar and click **+Create Your First Article**

* In the **New article** dialog, give the article a name. For the moment, we can call it README to signal that this is the wiki article team members should start reading.

* Since this is our first article, choosing the **Sample wiki article** template will provide us with a helpful outline and markdown examples.

* Click **Create**.

## Edit Your Article[¶](https://knowledge.dataiku.com/latest/kb/collaboration/wiki.html#edit-your-article "Permalink to this headline")

Dataiku DSS supports Markdown and HTML/CSS for formatting wiki articles. In Edit mode, the controls along the top of the edit area and the sample text should get us through common formatting options, and we can consult the reference documentation for details on Dataiku markdown support.

One feature worth calling out specially is the ability to reference Dataiku DSS objects within the wiki. You need to provide the name of the project that contains the object, the type of object, and then the name of the object itself. This creates a link in the finished wiki that teammates can follow.

The Actions menu allows you to:

* **Set home article**. This is the article displayed first when you visit the wiki.

* **Change parent article**. This changes the hierarchy of the wiki to place this article at the top level of the wiki or as the child of another article.

* **Switch to article/folder layout**. “Article” layout displays the article text with a list of attachments in the right panel. “Folder” layout displays the list of attachments below the article text, and the article can be expanded/collapsed for reading.

* **Rename**. Rename the article at any time. Take care, though, since this will break existing links to the article.

## Share Your Work[¶](https://knowledge.dataiku.com/latest/kb/collaboration/wiki.html#share-your-work "Permalink to this headline")

Your wiki is now visible to teammates browsing the project, and there are a few ways to broaden your audience.

### Dashboard Insight[¶](https://knowledge.dataiku.com/latest/kb/collaboration/wiki.html#dashboard-insight "Permalink to this headline")

You can add articles as insights on a Dataiku dashboard. This is useful for single-sourcing project reports, which can be written in the wiki for teammates, and then shared on the dashboard for readers.

### Promoted wikis[¶](https://knowledge.dataiku.com/latest/kb/collaboration/wiki.html#promoted-wikis "Permalink to this headline")

You can make a project wiki easier to find from the Dataiku homepage by promoting it. From the project’s Settings > Wiki, select **Display the wiki of this project in the global (instance-wide) wikis list**. The wiki will then appear in the list of wikis displayed on the Dataiku homepage.

### Home articles[¶](https://knowledge.dataiku.com/latest/kb/collaboration/wiki.html#home-articles "Permalink to this headline")

The Dataiku DSS administrator can select wiki pages to be used as “home articles” to convey the organization, procedures, and guidelines for using the instance and projects on the DSS instance.

* From **Administration Settings > Themes & Customization**, select the articles to add.

Home articles appear as tabs on the “Getting Started with DSS” You can see the homepage articles that are based on wikis in projects you have access to.

## What’s Next[¶](https://knowledge.dataiku.com/latest/kb/collaboration/wiki.html#what-s-next "Permalink to this headline")

Since wikis are a Dataiku DSS object, they inherit the features applicable to any object. For example, you can:

* Start a discussion on a wiki

* Find a wiki in the catalog

* Manipulate wikis with the API

Also see the Reference documentation for wikis.
