# How to Enable SQL Pipelines in the Flow[¶](https://knowledge.dataiku.com/latest/kb/data-prep/How-to-enable-SQL-pipelines-in-the-flow.html#how-to-enable-sql-pipelines-in-the-flow "Permalink to this headline")

A SQL recipe in your Flow reads an input dataset from storage, performs computations, and directs SQL to write the output. When you have a chain of visual and/or coding SQL recipes in your flow, repeating this read-write behavior for each recipe can result in slow performance. In such a situation, using SQL pipelines can boost performance by avoiding unnecessary writes and reads of intermediate datasets.

*Watch this short video below for an overview or read on for further details.*

## Enable SQL pipelines[¶](https://knowledge.dataiku.com/latest/kb/data-prep/How-to-enable-SQL-pipelines-in-the-flow.html#enable-sql-pipelines "Permalink to this headline")

To use the SQL pipelines feature in a Dataiku DSS Flow, the chain of recipes must share the same SQL connection. You can then enable SQL pipelines on a per-project basis.

* Go to the project’s Settings.

* Go to Pipelines.

* Select **Enable SQL pipelines**.

* Save settings.

*Enable SQL pipelines feature for the project*[¶](https://knowledge.dataiku.com/latest/kb/data-prep/How-to-enable-SQL-pipelines-in-the-flow.html#id1 "Permalink to this image")

Once enabled, you can then configure the behavior of intermediate datasets and recipes in your flow.

## Configure the behavior of intermediate datasets[¶](https://knowledge.dataiku.com/latest/kb/data-prep/How-to-enable-SQL-pipelines-in-the-flow.html#configure-the-behavior-of-intermediate-datasets "Permalink to this headline")

For intermediate datasets in the Flow, you can choose to enable or disable virtualization. Enabling virtualization can prevent DSS from writing the data of an intermediate dataset when executing the SQL pipeline.

To enable virtualization for a dataset:

* Open the dataset and go to the Settings tab at the top of the page.

* Go to the Advanced tab.

* Check **Virtualizable in build**.

To enable virtualization for multiple datasets at once:

* Select one or more datasets in the Flow.

* Locate the “Other actions” section in the right panel and select **Allow build virtualization (for pipelines)**.

*Enable virtualization for datasets*[¶](https://knowledge.dataiku.com/latest/kb/data-prep/How-to-enable-SQL-pipelines-in-the-flow.html#id2 "Permalink to this image")

## Configure the behavior of recipes[¶](https://knowledge.dataiku.com/latest/kb/data-prep/How-to-enable-SQL-pipelines-in-the-flow.html#configure-the-behavior-of-recipes "Permalink to this headline")

In addition to configuring the behavior of intermediate datasets, you can also specify how recipes in the Flow behave. To configure the behavior of the pipeline for each recipe:

* Open the recipe, and go to the Advanced tab at the top of the page.

* Check the options for “Pipelining”:

>

>

> 	+ “Can this recipe be merged in an existing recipe’s pipeline?”

> 	+ “Can this recipe be the target of a recipe’s pipeline?”

>

*Configure recipe behavior*[¶](https://knowledge.dataiku.com/latest/kb/data-prep/How-to-enable-SQL-pipelines-in-the-flow.html#id3 "Permalink to this image")

The first setting determines whether a recipe can be concatenated inside an existing SQL pipeline. The second setting determines whether running the recipe can trigger a new SQL pipeline.

## What’s Next?[¶](https://knowledge.dataiku.com/latest/kb/data-prep/How-to-enable-SQL-pipelines-in-the-flow.html#whats-next "Permalink to this headline")

The product documentation provides more details about SQL pipelines in Dataiku DSS.
