# How to fill empty cells of a column with the value of the corresponding row from another column[¶](https://knowledge.dataiku.com/latest/kb/data-prep/prepare-recipe/How-to-fill-empty-cells-of-a-column-with-the-value-of-the.html#how-to-fill-empty-cells-of-a-column-with-the-value-of-the-corresponding-row-from-another-column "Permalink to this headline")

Handling missing data is one data preparation challenge that analysts routinely face. Should you discard observations with missing values or perhaps impute missing values with a summary value like the median?

To handle missing data, the **Prepare** recipe has dozens of built-in processors ready to solve many of the most common challenges without any coding. In addition, Dataiku DSS has its own **Formula** language to craft more custom solutions.

For example, in some cases, you may want to fill the empty cells of a column with values of the corresponding rows from another column.

In a Prepare recipe, use the Formula processor with the coalesce() function as shown below:

*Here we fill the empty values of `col1` with the corresponding values of `col2` in a new column.*[¶](https://knowledge.dataiku.com/latest/kb/data-prep/prepare-recipe/How-to-fill-empty-cells-of-a-column-with-the-value-of-the.html#id1 "Permalink to this image")

You can also specify multiple columns, or even directly specify the missing values.

*Here we fill the empty values of `col1` with the values of `col2`, or `0` when `col2` is also empty.*[¶](https://knowledge.dataiku.com/latest/kb/data-prep/prepare-recipe/How-to-fill-empty-cells-of-a-column-with-the-value-of-the.html#id2 "Permalink to this image")

The Formula language gives you the flexibility to achieve more customized tasks. For example, you can combine functions in the same expression.

*Here we fill the empty values of `col1` with the corresponding floored values of `col2` in a new column.*[¶](https://knowledge.dataiku.com/latest/kb/data-prep/prepare-recipe/How-to-fill-empty-cells-of-a-column-with-the-value-of-the.html#id3 "Permalink to this image")

## Where can I find more information?[¶](https://knowledge.dataiku.com/latest/kb/data-prep/prepare-recipe/How-to-fill-empty-cells-of-a-column-with-the-value-of-the.html#where-can-i-find-more-information "Permalink to this headline")

See this article and video to learn more about using Formulas in Dataiku DSS.

## What’s next?[¶](https://knowledge.dataiku.com/latest/kb/data-prep/prepare-recipe/How-to-fill-empty-cells-of-a-column-with-the-value-of-the.html#whats-next "Permalink to this headline")

You can also learn more about visual data wrangling more broadly with Dataiku DSS with this series of hands-on tutorials.
