# How to pad a number with leading zeros[¶](https://knowledge.dataiku.com/latest/kb/data-prep/prepare-recipe/How-to-pad-a-number-with-leading-zeros.html#how-to-pad-a-number-with-leading-zeros "Permalink to this headline")

A common requirement when you have a column of numbers is to format all numbers so that they have the same length, adding leading zeros if needed.

This can be done in the **Prepare** recipe using a **Formula**.

The formula function to use is `format`. For example, to ensure that all values of the column *mycolumn* are padded to have a length of 11, including leading zeros, use: `format("%011d", mycolumn)`

It is useful to remember the usual formula rules to refer the values of columns, as described in the Dataiku DSS reference documentation.

For example, to do the same in a column named *my column* (note the space), you would use instead `format("%011d", numval("my column"))`

`format` is actually a very powerful function that uses Java string formatting capabilities. See this Java reference for more details.
