# Setup Single Sign On (SSO)[¶](https://knowledge.dataiku.com/latest/kb/dku-online/sso-setup.html#setup-single-sign-on-sso "Permalink to this headline")

Single sign-on (SSO) can be activated on Dataiku Online to enable your users to authenticate using your SAML 2.0-compliant organization’s identity provider (IdP).

Dataiku Online has been tested with the following identity providers:

* Okta

* Azure Azure Directory

* Microsoft AFDS

* Ping

This feature can be activated upon request by the support team with the information detailed below. To do so, you will first need to create an application in your identity provider to connect with our service, and then send us the information so our team can set it up.

## Create a Dataiku Online application in your identity provider[¶](https://knowledge.dataiku.com/latest/kb/dku-online/sso-setup.html#create-a-dataiku-online-application-in-your-identity-provider "Permalink to this headline")

First, you need to create a Dataiku Online application in your identity provider. Please check the documentation of your identity provider.

To do so you will need to provide the following information:

* Single sign on URL: `https://sso.dataiku.com/login/callback`

* Audience URI: `urn:auth0:dataiku:*dataiku\_space\_id*`

You need to replace `dataiku\_space\_id` by your Dataiku Online space ID that can be found in the Settings tab of your Launchpad:

Map the following value to the relevant attribute in your identity provider or fixed value:

* `user.firstName` to the attribute representing the user’s first name

* `user.lastName` to the attribute representing the user’s last name

* `user.login` to the attribute representing the user’s email address

* `user.email` to the attribute representing the user’s email address

* Email verified set to the value “True”

## Contact us with the correct information[¶](https://knowledge.dataiku.com/latest/kb/dku-online/sso-setup.html#contact-us-with-the-correct-information "Permalink to this headline")

You will need to gather the following information:

* The single-sign-on (SSO) URL for your identity provider

* The x.509 certificate

* Or your identity provider Metadata link

* The email domain you wish to use with SAML

Mail this information to support-online@dataiku.com or send it in the chat on Dataiku Online to get the SSO activated on your subscription. We will get back to you when the setup is ready or if we need additional information.
