# How-To: Set Up Dataiku Workspaces[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/workspaces/setting-up-workspaces.html#how-to-set-up-dataiku-workspaces "Permalink to this headline")

Workspaces are a collaboration channel between analytics teams and the audiences they serve - a private space and single point of access where data consumers can easily find, review, and discuss all the Dataiku assets they need related to a business initiative, even if they’re sourced from different projects. Dataiku released Workspaces in version 10.

You may be asking yourself *“what’s the best way to set up workspaces for my analytics team and my AI consumers?”*. This article outlines some various options for designing workspaces and how one might assign roles to various people in an organization.

As you learn about Workspaces, consider these questions to help you identify the best structure for you and your teams:

* How is your organization organized internally?

* How are departments/ business units structured?

* Are there sub-teams you need to account for?

* Do you work with stakeholders who need to be siloed in their own teams?

* Who should be allowed to create workspaces?

* Who should be responsible for adding and removing people from workspaces?

* Who should be responsible for adding relevant content to each workspace?

## Single vs. Multi-Workspace Design[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/workspaces/setting-up-workspaces.html#single-vs-multi-workspace-design "Permalink to this headline")

The number of workspaces your team will create in Dataiku DSS will vary depending on: your team size, how many people you want to share content with, and the variety of functional areas your work covers.

If you only work with one set of stakeholders, you can consider a **single workspace**. In this setup, there is only one workspace on the Dataiku DSS instance. It’s a good choice to make when all business stakeholders are on the same functional team or when the content you want to publish into a workspace can be shared with everyone in the workspace.

**Pros:**

* Easier workspace management (only add users to one workspace)

**Cons:**

* As the workspace grows, content might be less likely to apply to everyone, resulting in a “messy” workspace for stakeholders.

As your deployment gets bigger, you might decide to set up multiple workspaces and give each functional area its own Dataiku Workspace. It’s a model to consider when objects need to be kept private amongst smaller groups of people or when the functional scope of your stakeholders differs widely. Users with transversal analytics needs can belong to more than one workspace. Most teams will opt for a multi-workspace setup.

**Pros:**

* Workspaces contain assets relevant to everyone in the workspace.

* Workspace admins can take a high-level of ownership when managing who is in the workspace.

**Cons:**

* Some functional scope may overlap and contributors might need to share the same object to multiple workspaces.

* Large numbers of workspaces can be challenging to administer.

Tip

For content that is non-sensitive and should be accessible to everyone, you might consider creating one, large Workspace that contains all Dataiku DSS users, and then creating smaller workspaces for specialized content. This workspace could be filled with content ranging from onboarding materials to KPIs that everyone will want to track.

You can simplify granting access to a large group like this with a built-in group, ‘All Users’, that can be added to a workspace.

## Workspace Roles and Rights[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/workspaces/setting-up-workspaces.html#workspace-roles-and-rights "Permalink to this headline")

### Permissions and Roles Overview[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/workspaces/setting-up-workspaces.html#permissions-and-roles-overview "Permalink to this headline")

A Dataiku instance can have several projects and workspaces under its umbrella, in addition to various models for granting permissions at the instance, project, and workspace levels.

### Instance-Level Permissions[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/workspaces/setting-up-workspaces.html#instance-level-permissions "Permalink to this headline")

In addition to creating Dataiku DSS users, **instance admins** can create groups and administer them. Group permissions are assigned at the instance level and include permissions like “Create projects”, “Develop plugins”, etc.

Instance admins should assign **“create workspaces”** and **“share to workspaces”** privileges to the appropriate groups of users. Without granting these permissions, only instance admins will be able to create workspaces and share content from projects. These two permissions are accessible under **Administration** > **Security** > **Groups**.

Note that instance admins can access and administer all projects and workspaces.

### Project-Level Permissions[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/workspaces/setting-up-workspaces.html#project-level-permissions "Permalink to this headline")

At the project level, the **project admin** controls the scope of access they grant to their project to any Dataiku DSS user.

Project admins should grant **“share to workspace”** privileges to designated users and enable them to share objects into workspaces. Users with this permission will also need permission from the instance admin (see previous section) to share an object with a community of users in a workspace.

### Workspace-Level Permissions[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/workspaces/setting-up-workspaces.html#workspace-level-permissions "Permalink to this headline")

Individual workspaces are managed by **workspace admins** who manage the users who have access to content in a workspace.

There are three workspace roles : Admin, Contributor, and Member. **Admins** can add / remove users and assign roles. **Contributors** contribute content from projects into a workspace; they can also remove content. They’ll need “share to workspace” privileges at the instance level as well as “share to workspace” privileges from the appropriate projects in order to fully exercise their role. **Members** have view access to whatever content has been shared into a workspace; they don’t have access to the originating projects unless granted separately by the project admin.

## Workspace Structures[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/workspaces/setting-up-workspaces.html#workspace-structures "Permalink to this headline")

The type of structure your team will adopt will vary depending on its size and how you prefer to use Dataiku DSS to share content with your business users. Below are outlined two common structures for setting up permissions and roles for workspaces.

The first is a more centralized model that will be a good choice for stricter control and governances on workspaces; the second is more open and collaborative, allowing teams the greatest amount of autonomy and flexibility.

You will likely find that the best balance for your team lies somewhere between the two.

### Centralized Structure[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/workspaces/setting-up-workspaces.html#centralized-structure "Permalink to this headline")

Instance admins retain workspace creation (instance) privileges and grant “share workspace” (instance) privileges to project admins. With each new workspace, the instance admin grants someone the workspace admin role, allowing them to autonomously manage workspace membership.

When a new workspace is needed, the instance admin creates it. They grant the “workspace admin” role to a user who will be in charge of managing workspace membership. The workspace admin grants the Contributor role to whoever will be publishing content into their workspace and grants the Member role to all other users. Any new workspace users will be added to their respective workspaces by the relevant workspace admin.

To control how content is shared from projects, the instance admin grants “share to workspace” privileges to a group of project admins. Those project admins are given the Contributor role to the relevant workspaces and publish content from their projects into the workspace.

**Pros:**

* Manage the proliferation of workspaces;

* Tighter control over sharing content from projects.

**Cons:**

* New workspace creation can be bottlenecked through the instance admin;

* Restrictive content sharing policy.

### Delegated Structure[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/workspaces/setting-up-workspaces.html#delegated-structure "Permalink to this headline")

The instance admin delegates “create workspace” (instance) privileges to a group of users who will administer workspaces and “share to workspace” (instance) privileges to a group of users who will moderate workspace content.

The instance admin delegates “create workspace” (instance) privileges to a group of users who will be workspace Admins. Any new workspace can be created and managed by a group of workspace Admins, allowing them to manage Workspaces–and any associated process–autonomously.

Then, the instance admin will grant “share to workspace” (project) privileges to a group of Designers who will be responsible for publishing content into a workspace when it’s ready. These are the users who will be the primary points of contact for any stakeholder questions.

Project admins grant those same designers “share to workspace” (project) privileges in the necessary project(s), allowing the Designers to share an object outside of the project. At the same time, the workspace Admins grant those Designers a Contributor role so that they can publish objects into the relevant workspace.

**Pros:**

* Teams and stakeholder groups can autonomously create workspaces as needed;

* Easy to share content into workspace from a variety of projects.

**Cons:**

* Can lead to a proliferation of workspaces;

* Harder to effectively manage large numbers of workspaces.

## Go Further[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/workspaces/setting-up-workspaces.html#go-further "Permalink to this headline")

This article introduced the concept of Dataiku Workspaces and the various ways and strategies one might apply to creating, organizing, and managing workspaces.

To learn more:

* check out this hands-on tutorial; or

* read the product documentation on workspaces.
