# Readme

You can find the full instructions for running this project in the [Developer Guide's Getting Started tutorial](https://developer.dataiku.com/latest/getting-started/quickstart-tutorial/index.html).

The goal of this project is to predict heart attack failures, using the [Heart Failure Prediction Dataset](https://www.kaggle.com/datasets/fedesoriano/heart-failure-prediction). Using Python notebooks and Dataiku Machine Learning experiment tracking capabilities, the project will go through data preparation, machine learning experimentation using classic scikit-learn models, and model evaluation.

## Configuration

### 1. Create a Python code environment

To run the notebooks and the different Python components of this project, you'll need to create a Python>=3.8 [code environment](https://doc.dataiku.com/dss/latest/code-envs/index.html) named `py_quickstart` with the following required packages:

```python
mlflow
scikit-learn>=1.0,<1.4
scipy<1.12.0
statsmodels
seaborn
```

[Instructions for creating a new code environment](https://doc.dataiku.com/dss/latest/code-envs/operations-python.html#create-a-code-environment)

### 2. Set the new code environment as default for the project

To make sure the code environment is automatically selected to run all the scripts in your project, we will change the project settings to use it by default.

- On the top bar, select: `...`>`Settings`>`Code env selection`
- In the **Default Python code env**:
  - Change *Mode* to `Select an environment`
  - In the *Environment* parameter, select the code environment you've just created
  - Click 'Save' or do a Ctrl+S

## How to run the project

In the following tutorial, you'll find guidelines for using the different notebooks to experiment and build your project pipeline. Ensure you use the code environment specified in the **Prerequisites** (`py_quickstart`). You can change the Python kernel in the Notebook menu under **Kernel > Change Kernel**.

## Project overview

The project comes with:

- an [input dataset](dataset:heart_measures)
- three Jupyter Notebooks that we will use to explore that data, experiment and build the project pipeline (the Flow).
- a Python repository stored in the [project library](https://doc.dataiku.com/dss/latest/python/reusing-code.html#sharing-python-code-within-a-project), with some functions that we will use in the different notebooks

To build the project and create the pipeline, you can run the notebooks one by one in the order described above and follow the instructions described in the notebooks.

### Step 1: Data Preparation

The [first notebook](jupyter_notebook:1 - Prepare the heart_measures dataset for ML modeling) performs a quick data analysis of the input dataset, applies a few data cleaning steps, using some Python functions stored in the project library repository, and splits the prepared dataset into a train and a test set.

*Hint*: Don't forget to follow the instructions in the **4. Next: use this notebook to create a new step of the pipeline** section of the notebook to create a preparation step on the project pipeline (the Flow). This step is required for the rest of the project.

### Step 2: Machine Learning experimentation

The [second notebook](jupyter_notebook:2 - Experiment different ML approaches) tests different machine learning models and parameters to predict heart failures. It stores all the experiments in our experiment tracking tool.

### Step 3: Deployment and evaluation of the best-performing model

The [third notebook](jupyter_notebook:3 - Create a Saved Model using the best performing model) collects the best model optimizing the chosen metric (accuracy) from the experiment tracking tool to deploy it in the project Flow.

*Hint*: Don't forget to follow the instructions in the **5. Next: use this notebook to create a new step on the pipeline** section of the notebook to create a new step on the project pipeline (the Flow) and evaluate the model on the test dataset.
