import dataiku
from dataiku.llm.agent_tools import BaseAgentTool

from agentic_insights.backend.agentic_insights_toolkit.adm.common import get_analysis_report_folder
from agentic_insights.backend.agentic_insights_toolkit.dku_utils.utils import read_file_from_folder

class MyAgentTool(BaseAgentTool):
    """An empty interface for a code-based agent tool"""

    def __init__(self):
        pass

    def get_descriptor(self, tool):
        """
        Returns the descriptor of the tool, as a dict containing:
           - description (str)
           - inputSchema (dict, a JSON Schema representation)
        """
        return {
            "description": "Retrives the content of the selected analysis report.",
            "inputSchema" : {
                "$id": "analysis_report_retriever",
                "title": "Analysis Report Retriever",
                "type": "object",
                "properties": {
                    "analysis_session_id": {
                        "type": "str",
                        "description": "The ID of the analysis session."
                    },
                },
                "required": ["analysis_session_id"]
            }
        }


    def invoke(self, input, trace):
        """
        Invokes the tool.

        The arguments of the tool invocation are in input["input"], a dict
        """
        analysis_session_id = input["input"]['analysis_session_id']
        
        output = ""
        try:
            report_folder = get_analysis_report_folder()
            output = read_file_from_folder(folder = report_folder, file_name = f"{analysis_session_id}.html")
            
        except Exception as e:
            output = f"❌ Failed to read analysis report: {e}"

        return {
            "output": output,
            "sources": [],
        }
