import dataiku
from dataiku.llm.agent_tools import BaseAgentTool

from agentic_insights.backend.agentic_insights_toolkit.utils.analysis_session import get_available_business_rules
from agentic_insights.backend.agentic_insights_toolkit.utils.common import convert_df_to_str


class MyAgentTool(BaseAgentTool):
    """An empty interface for a code-based agent tool"""

    def __init__(self):
        pass

    def get_descriptor(self, tool):
        """
        Returns the descriptor of the tool, as a dict containing:
           - description (str)
           - inputSchema (dict, a JSON Schema representation)
        """
        return {
            "description": "Retrieve business rules.",
            "inputSchema" : {
                "$id": "business_rules_explorer",
                "title": "Business Rules Explorer",
                "type": "object",
                "properties": {},
                "required": []
            }
        }


    def invoke(self, input, trace):
        """
        Invokes the tool.

        The arguments of the tool invocation are in input["input"], a dict
        """
        df_rules = get_available_business_rules()

        if df_rules.empty:
            output = "No Business Rules"
        
        else:
            df_rules_str = convert_df_to_str(df_rules)
            output = df_rules_str
        
        return {
            "output": output,
            "sources": [{
                "toolCallDescription": "Retrieved active business rules",
                "items": []
            }]
        }
