import dataiku
from dataiku.llm.agent_tools import BaseAgentTool

from agentic_insights.backend.agentic_insights_toolkit.utils.agent_assets import explore_dataset



class MyAgentTool(BaseAgentTool):
    """An empty interface for a code-based agent tool"""

    def __init__(self):
        pass

    def get_descriptor(self, tool):
        """
        Returns the descriptor of the tool, as a dict containing:
           - description (str)
           - inputSchema (dict, a JSON Schema representation)
        """
        return {
            "description": "Returns schema and preview for one or more datasets in a structured text format.",
            "inputSchema" : {
                "$id": "autoinsight_dataset_explorer",
                "title": "Auto-Insight Dataset Explorer",
                "type": "object",
                "properties": {
                    "dataset_names": {
                        "type": "list[str]",
                        "description": "List of dataset names in the Dataiku project to explore."
                    },
                    "limit": {
                        "type": "int",
                        "description": "Maximum number of rows to load from the dataset. If None, loads the entire dataset. Defaults to 5"
                    }
                },
                "required": ["dataset_names", "limit"]
            }
        }


    def invoke(self, input, trace):
        """
        Invokes the tool.

        The arguments of the tool invocation are in input["input"], a dict
        """
        datasets_to_explore = input["input"]['dataset_names']
        limit = input["input"].get("limit", 10)
        
        limit = min(limit, 10)
        
        
        outputs = [explore_dataset(dataset_name=d, limit = limit) for d in datasets_to_explore]
        concat_outputs = "\n---\n".join(outputs).strip()
            
        return {
            "output": concat_outputs,
            "sources": [],
        }
