import uuid

import dataiku

from ..dku_utils.object import get_or_create_managed_folder

def get_resource_folder(folder_name = "resources"):
    folder = get_or_create_managed_folder(folder_name = folder_name)
    return folder

def get_analysis_session_history_folder(folder_name = "analysis_session_history"):
    folder = get_or_create_managed_folder(folder_name = folder_name, create_if_not_exist=True)
    return folder

def get_analysis_report_folder(folder_name = "analysis_reports"):
    folder = get_or_create_managed_folder(folder_name = folder_name, create_if_not_exist=True)
    return folder

def get_analysis_zone_default_metadata():
    """
    Default tags applied to analysis-related Flow Zones.
    """
    metadata = {
        "tags": ["agentic-insights", "ai-generated"],
        "color": "#F9BE40"
    }
    return metadata

def generate_analysis_session_id():
    return f"analysis_session_{str(uuid.uuid4())[:8]}"


