from dotenv import load_dotenv
import sys
import os
from pathlib import Path

def _is_dss_environment():
    """Détecte si on est dans un environnement Dataiku DSS."""
    # En DSS, DKU_CURRENT_PROJECT_KEY est toujours défini
    if os.getenv("DKU_CURRENT_PROJECT_KEY"):
        return True
    
    # Vérifier si on peut accéder au module dataiku (disponible uniquement en DSS)
    try:
        import dataiku
        # Essayer d'accéder au projet par défaut (fonctionne uniquement en DSS)
        dataiku.api_client().get_default_project()
        return True
    except (ImportError, Exception):
        return False

def init_config():
    # Charger les variables d'environnement depuis .env uniquement en local
    # En DSS, les variables d'environnement sont déjà configurées
    if not _is_dss_environment():
        load_dotenv()
