import axios_ from "axios"

interface WindowWithGetWebAppBackendUrl extends Window {
  getWebAppBackendUrl?: (arg: string) => string;
}

declare const window: WindowWithGetWebAppBackendUrl
declare const parent: WindowWithGetWebAppBackendUrl

function getBackendProdUrl() {
  const getWebappBackendUrlFn = window.getWebAppBackendUrl || parent.getWebAppBackendUrl
  if (typeof getWebappBackendUrlFn === 'function') {
    return getWebappBackendUrlFn('')
  }
  return null
}

let baseURLVite = import.meta.env.BASE_URL

const backendProdBase = getBackendProdUrl()
const localBackendPort = import.meta.env.VITE_API_PORT
const localClientPort = import.meta.env.VITE_CLIENT_PORT

if (localClientPort && localBackendPort) {
  baseURLVite = baseURLVite.replace(localClientPort, localBackendPort)
}

const baseURL = backendProdBase != null ? backendProdBase : baseURLVite

const axios = axios_.create({ baseURL })

axios.interceptors.request.use(
  (config) => {
    console.log(`[API Request] ${config.method?.toUpperCase()} ${config.url}`, config.data)
    return config
  },
  (error) => {
    console.error("[API Request Error]", error)
    return Promise.reject(error)
  }
)

axios.interceptors.response.use(
  (response) => {
    console.log(`[API Response] ${response.config.method?.toUpperCase()} ${response.config.url}`, response.data)
    return response
  },
  (error) => {
    console.error(`[API Error] ${error.config?.method?.toUpperCase()} ${error.config?.url}`, error.response?.data || error.message)
    APIErrors.push(error.response)
    return Promise.reject(error)
  }
)

export const APIErrors: any[] = []

export default axios
export { baseURL }
