/**
 * Format a date ISO string to a readable format
 */
export function formatLastLaunchTime(isoString: string): string {
  try {
    const date = new Date(isoString)
    return date.toLocaleString('en-US', {
      year: 'numeric',
      month: 'short',
      day: 'numeric',
      hour: '2-digit',
      minute: '2-digit',
      second: '2-digit',
      hour12: true
    })
  } catch (error) {
    return isoString
  }
}

/**
 * Get the color class for a status
 * Matches the button color: orange for running, blue for ready/normal
 */
export function getStatusColor(status: string | null): string {
  if (!status) return 'text-gray-400'
  
  const statusLower = status.toLowerCase()
  switch (statusLower) {
    case 'running':
    case 'warning':
      return 'text-orange-500' // Matches the orange button when running/warning
    case 'success':
    case 'completed':
      return 'text-green-500'
    case 'failed':
    case 'aborted':
      return 'text-red-500'
    default:
      return 'text-blue-500' // Matches the blue button when ready
  }
}

/**
 * Format a status string to a readable format
 */
export function formatStatus(status: string | null): string {
  if (!status) return ''
  
  const statusLower = status.toLowerCase()
  switch (statusLower) {
    case 'running':
      return 'Running'
    case 'warning':
      return 'Warning'
    case 'success':
      return 'Success'
    case 'completed':
      return 'Completed'
    case 'failed':
      return 'Failed'
    case 'aborted':
      return 'Aborted'
    default:
      return status
  }
}

