<span id="version" style="color: grey; float: right">Version 1.0.0</span><br/>

# Agentic Insights: Automated AI Data Analysis

An intelligent agent-based solution that automates the complete data analysis workflow from data exploration to report generation. The system leverages AI agents to perform comprehensive analyses, apply business rules, execute multiple analytic tools, and deliver decision-ready reports with integrated AI assistance for enhanced understanding.


![agentic_insights_homepage.png](hGhAhBB8AIPh)


<br>

## Industry Challenge
---

Data Analysts and Business Users need to **extract actionable insights** from complex datasets while ensuring **compliance with organizational policies** and maintaining **consistency in analysis methodology**. 

Their workflow typically involves multiple manual steps, siloed tools, and repetitive tasks which act as barriers to efficiency and scalability in data-driven decision making.

Success depends on multiple factors:
- Comprehensive analysis coverage across different analytical dimensions (clustering, outlier detection, forecasting, root cause analysis)
- Consistent application of business rules and organizational policies throughout the analysis
- Efficient interpretation and understanding of analysis results to drive actionable recommendations
- Scalable approach that can handle various datasets and analysis requirements without extensive manual configuration

<br>

## Agent Value
---

We harness the power of Dataiku Visual Agents and Agent Hub to create an intelligent analysis system. The Main Agent orchestrates the complete analysis workflow, automatically exploring datasets, applying business rules, executing multiple analytic tools in parallel, and generating comprehensive HTML reports. The Report Assistant Agent provides contextual help and answers questions about analysis results through an intuitive chatbot interface.

The webapp provides a user-friendly interface for launching analyses and exploring results, allowing users to:
- **Automated Analysis Execution**: Configure analysis parameters once and let the agent handle the complete workflow from data exploration to report generation
- **Comprehensive Insights**: Access multiple types of analyses (clustering, outlier detection, forecasting, root cause analysis) in a single session
- **Business Rule Compliance**: Ensure all analyses automatically comply with organizational policies and constraints
- **Enhanced Understanding**: Interact with an AI assistant to explore reports, understand findings, and discover actionable insights

<br>

## Project Highlights

- **Main Agent** (`va_main_agent`): Orchestrates complete analysis workflow with different specialized tools for dataset exploration, business rules application, analytic tool execution, and report generation
- **Report Assistant Agent** (`va_report_assistant`): Provides AI-powered assistance for exploring and interpreting analysis reports through Agent Hub's unified chat interface
- **Modern Webapp**: Built with Vue 3 and Flask, providing an intuitive interface for launching analyses and managing historical sessions
- **Flexible Configuration**: Support for custom business rules, multiple analytic tools, and configurable analysis parameters
- **Integrated AI Assistance**: Seamless integration of Report Assistant Agent directly in the report viewer for enhanced user experience