## Prerequisites

Before going through the practical use cases, complete the following setup:
- Refer to the **Installation section** first before proceeding with these use cases.
- Import an initial dataset and place it in the **Input Datasets** Flow Zone

![usage_input_datasets_zone.png](VWJqYoHC75FT)



- Ensure the dataset is properly formatted and ready for analysis. Here we are using a dataset that contains Global Superstore sales data with customer, order, and product details.

![usage_input_dataset.png](k2g7Pb43TCnO)

<br>

## Use Case 1: Perform Exhaustive Analysis with Default Parameters (Automatic Mode)

**Objective**: Launch a complete analysis using all available analytic tools with default settings, allowing the agent to automatically infer parameters and generate a comprehensive report.

- 1) **Select the input dataset**: Choose your dataset from the dropdown in the Session Parameters section

![usage_uc1_input_dataset_selection.png](5vO9hmSXN9f3)


- 2) **Launch the analysis**: Click the "Launch Analysis" button to start the analysis session

![usage_uc1_launch_btn.png](UZ9vy2y58P2T)
![usage_uc1_launch_btn_running.png](xmxBDG6KElQi)

- 3) **View the report**: Once the analysis completes, the report automatically opens in the Report Viewer section

![usage_uc1_report_1.png](Y3x6436OtTfp)
![usage_uc1_report_4.png](kmg73UcfXyev)
![usage_uc1_report_5.png](REokoGmfvIax)


- 4) **Interact with AI Assistant**: Enable the AI Assistant toggle to ask questions about the report and explore insights

![usage_uc1_report_with_assistant.png](HZ7oQkfFNudz)

<br>

![usage_uc1_report_assistant_config.png](BzZ03XHrEBjA)

<br>

![usage_uc1_report_assistant_query.png](hLS7L58cEN8w)

<br>

![usage_uc1_report_assistant_query_answer.png](k2IRG7KjA83H)




<br>

## Use Case 2: Perform Customized Analysis by Manually Selecting Parameters

**Objective**: Launch a targeted analysis by selecting specific analytic tools and providing custom parameters, such as manually specifying the target variable for Root Cause Analysis.

- 1) **Select the input dataset**: Same as Use Case 1

- 2) **Customize parameters**:
   - **Select specific analyses**: Expand the "Analysis To Perform" section and select only Root Cause Analysis

![usage_uc2_analysis_options.png](g39nH3lZt4j0)

   - **Select target variable manually**: Disable "Infer Target Variable" and choose the target column from the dropdown

![usage_uc2_analysis_rca_target_options.png](uK9QpLCAOQ9C)

   - **Provide additional context**: Add specific requirements or instructions in the "Additional Analysis Context" field

![usage_uc2_analysis_add_context.png](NzhfhFkZYgzu)


- 3) **Launch the analysis**: Click the "Launch Analysis" button

- 4) **View the report**: Review the generated report focused on Root Cause Analysis

![usage_uc2_report.png](nl4n4dwwaqI4)

- 5) **Interact with AI Assistant**: Use the AI Assistant to explore the analysis results


<br>


## Use Case 3: Perform Exhaustive Analysis with Business Rules

**Objective**: Launch a complete analysis while applying organizational business rules to ensure compliance with company policies and constraints.

- 1) **Select the input dataset**: Same as Use Case 1

- 2) **Enable business rules**:
   - **Configure business rules**: Add or update business rules in the `business_rules` dataset (click "Open Dataset" to view)
   - For this example, we will add a business rule specifying that the 'Discount' variable must not be used as an explanatory factor in root cause analysis.

![usage_uc3_business_rules_dataset.png](ziZ6wuAyWSDU)

   - **Enable business rules**: Toggle the "Use Internal Business Rules" switch to activate business rules for this analysis

![usage_uc2_analysis_add_context.png](NzhfhFkZYgzu)

- 3) **Launch the analysis**: Click the "Launch Analysis" button

- 4) **View the report**: Review the generated report that complies with the specified business rules

![usage_uc3_report.png](wWH9B1oStlvQ)

- 5) **Interact with AI Assistant**: Use the AI Assistant to understand how business rules influenced the analysis

<br>

## Use Case 4: View Historical Analysis Sessions

**Objective**: Access and review previously completed analysis sessions, including their reports and metadata.

- 1) **Open Historical Analysis tab**: Navigate to Tab 2 "Historical Analysis" from the sidebar

![usage_uc4_tab_2.png](ENnkAguTAxt1)


- 2) **View specific report**: Click the "View" button next to the desired analysis session in the table

![usage_uc4_table_view_button.png](NoPUmFYsVsaM)

- 3) **View report and interact with Assistant**: The report loads in the Report Viewer, and you can enable the AI Assistant to explore the historical analysis


<br>


## Use Case 5: Clean Historical Sessions

**Objective**: Delete one or multiple historical analysis sessions to manage storage and keep only relevant analyses.

- 1) **Open Historical Analysis tab**: Navigate to Tab 2 "Historical Analysis"

- 2) **Select multiple sessions**: Use the checkboxes to select the sessions you want to delete

![usage_uc5_bulk_selection.png](KVVbnmBZvHh3)

- 3) **Delete selected sessions**: Click the "Delete Selected" button and confirm the deletion

![usage_uc5_bulk_delete_confirmation.png](Gk51G2RAMhKR)

- 4) **Verify deletion**: The table updates automatically, showing fewer sessions after deletion

![usage_uc5_bulk_delete_results.png](X1hAZi7fEiI6)

