The Report Assistant Agent has access to a set of specialized tools, each described below.

<br>

## [Analysis Session Parameters Retriever](agent_tool:m1VBPV1)

**Purpose**: Retrieve the session parameters for the current analysis session.

**Capabilities**:
- Retrieves analysis session ID
- Gets input datasets used in the analysis
- Retrieves selected analyses that were performed
- Gets additional context and configuration parameters

**Usage**:
- Called at the beginning to understand the analysis context
- Provides essential information about what analysis was performed
- Helps the agent understand the scope and parameters of the analysis

**Output**: 
- Analysis session ID
- Input datasets
- Selected analyses
- Additional session parameters

<br>

## [Analysis Report Retriever](agent_tool:3gfisbl)

**Purpose**: Retrieve the full generated analysis report for inspection and interpretation.

**Capabilities**:
- Retrieves the complete HTML report generated by the Main Agent
- Accesses all report sections, metrics, and visualizations
- Provides access to structured data embedded in the report

**Usage**:
- Used to answer questions about report content
- Helps interpret findings and metrics
- Enables summarization of report sections

**Output**: 
- Complete HTML report content
- Report sections and structure
- Embedded data and metrics


<br>

## [Dataset Explorer](agent_tool:v9OSAm3)

**Purpose**: Explore dataset structure, schema, statistics, missing values, and anomalies.

**Capabilities**:
- Inspect dataset schemas (columns, data types)
- Analyze data distributions
- Identify missing data patterns

**Usage**:
- Used to help users understand the underlying data
- Explains data quality issues mentioned in reports
- Provides context for analysis results
- Helps validate findings from the report

**Output**: 
- Schema information
- Data quality metrics
- Sample data


<br>


## [Analysis Flow Retriever](agent_tool:SRHLChb)

**Purpose**: Retrieve and describe the Dataiku Flow used to produce the analysis.

**Capabilities**:
- Retrieves the complete flow structure
- Describes the sequence of analytic steps
- Explains how datasets are connected
- Identifies recipes and transformations used

**Usage**:
- Used to explain how the analysis was performed
- Helps users understand the methodology
- Provides context for the analysis workflow
- Explains dependencies between steps

**Output**: 
- Flow structure and components
- Sequence of analytic steps
- Dataset connections
- Recipe descriptions
