## Overview
---

The webapp is a modern, full-stack application built with Vue 3 and Flask that provides an intuitive interface for launching and managing AI-powered data analysis sessions. It serves as the primary user interface for the Agentic Insights project, enabling users to configure analysis parameters, monitor execution, and interact with generated reports through an integrated AI assistant.

The application follows a component-based architecture with centralized state management, providing a responsive and user-friendly experience for both launching new analyses and exploring historical results.

<br>

## Development Framework
---

The webapp is built using modern frontend technologies:

- **Vue 3**: Progressive JavaScript framework with Composition API
- **shadcn-vue**: Component library providing accessible, customizable UI components for Vue
- **TypeScript**: Type-safe JavaScript for better code quality
- **Vite**: Fast build tool and development server
- **Pinia**: State management library for Vue
- **Tailwind CSS**: Utility-first CSS framework
- **Axios**: HTTP client for API requests

### Key Features

- **Type Safety**: Full TypeScript support throughout the application
- **Component-Based Architecture**: Modular Vue components with Composition API
- **Responsive Design**: Tailwind CSS for modern, responsive UI
- **State Management**: Centralized state with Pinia stores
- **API Integration**: RESTful API communication via Axios

<br>

## Core Modules
---

### Main Components

#### Layout Components
- **`App.vue`**: Root component with sidebar and tab navigation
- **`Sidebar.vue`**: Navigation sidebar with menu items
- **`NewAnalysis.vue`**: Tab component for launching new analyses
- **`HistoricalAnalysis.vue`**: Tab component for viewing historical sessions

#### Feature Components
- **`SessionParameters.vue`**: Form for configuring analysis parameters
- **`AnalysisLauncher.vue`**: Component for launching analysis sessions
- **`ReportSection.vue`**: Displays analysis reports and AI assistant
- **`HistoricalSessionsTable.vue`**: Table view of historical analysis sessions
- **`AIAssistantIframe.vue`**: Iframe wrapper for Report Assistant Agent

#### UI Components (`src/components/ui/`)
- Reusable UI components built with shadcn-vue
- Accessible, customizable components following shadcn-vue patterns
- Includes: buttons, cards, inputs, selects, tables, sidebars, tags-input, tooltips, etc.
- Uses Lucide icons (`lucide-vue-next`) for iconography

<br>

### API Layer (`src/Api.ts`)

**Role**: Centralized API client that provides a clean interface for all backend communication. It abstracts HTTP requests and provides type-safe methods for interacting with the Flask backend API.

**Components**:
- **Session Management**: Methods for creating, retrieving, and deleting analysis sessions
- **Configuration Data**: Endpoints to fetch available analysis types, input datasets, and report templates
- **Report Operations**: Functions to retrieve analysis reports and manage report-related data
- **Agent Integration**: Utilities for accessing Report Assistant Agent webapp paths

**Implementation**: Built on top of Axios, with TypeScript interfaces for request/response types. All follow RESTful conventions.

<br>

### Utilities

- **`src/utils/analysis.ts`**: Analysis-related utility functions
- **`src/utils/analysisTypes.ts`**: Type definitions for analysis options
- **`src/utils/statusUtils.ts`**: Status management utilities
- **`src/lib/utils.ts`**: General utility functions

<br>

### State Management (Stores)

**Role**: Centralized state management using Pinia stores. Provides reactive state that persists across components and enables efficient data sharing and synchronization throughout the application.

**Components**:

- **`analysisStore`** (`src/stores/analysisStore.ts`): Manages analysis session lifecycle and report operations
  - Tracks current and historical analysis sessions
  - Handles report fetching with polling mechanisms
  - Provides session status management and persistence via localStorage

- **`optionsStore`** (`src/stores/optionsStore.ts`): Manages application configuration and available options
  - Caches analysis types and input datasets from the API
  - Implements smart caching with localStorage for performance
  - Supports force refresh to bypass cache when needed

- **`appStore`** (`src/stores/appStore.ts`): General application-wide state and settings

**Features**: All stores use Vue 3 Composition API with reactive refs, providing type-safe state management with automatic reactivity and persistence capabilities.

<br>

## Backend
---

**Role**: Flask-based backend API that serves as the bridge between the frontend webapp and Dataiku's analysis infrastructure. Handles all server-side operations including session management, scenario execution, and data retrieval.

**Architecture**:
- **Framework**: Flask web framework with Blueprint-based routing
- **Integration**: WEBAIKU extension for seamless Dataiku DSS integration
- **API Design**: RESTful endpoints prefixed with `/api`
- **CORS**: Configured for local development cross-origin requests

**Components**:

- **WSGI Configuration**:
  - `wsgi_dss.py`: Production deployment configuration for Dataiku DSS
  - `wsgi_local.py`: Local development setup with CORS and debugging enabled

- **API Layer** (`backend/api/`):
  - `analysis_session_api.py`: Main Flask Blueprint containing all analysis-related endpoints
  - `utils.py`: Shared utility functions for API operations

- **Core Functionality**:
  - **Session Management**: Endpoints for creating, retrieving, and managing analysis sessions
  - **Analysis Execution**: Triggers Dataiku scenarios and monitors execution status
  - **Data Retrieval**: Fetches analysis reports, metadata, and configuration data
  - **Agent Integration**: Provides paths and configuration for Report Assistant Agent access

**Deployment Modes**:
- **Local Development**: Standalone Flask server with CORS enabled, separate from Dataiku
- **DSS Production**: Integrated into Dataiku's webapp system via WEBAIKU, no CORS needed

<br>

## Deployment
---

**Role**: Provides two distinct deployment modes - local development for rapid iteration and Dataiku DSS deployment for production use. Each mode has optimized configurations for its specific environment.

**Dataiku DSS Deployment**:

- **Build Process**: 
  - TypeScript type checking with `vue-tsc`
  - Production build with Vite optimization
  - Output: Static files in `dist/` directory

- **Integration**:
  - Frontend served via WEBAIKU extension from built `dist/` directory
  - Backend code deployed as part of Dataiku project
  - Automatic API endpoint registration via Flask Blueprint
  - Environment detection for seamless DSS integration

- **Configuration**: 
  - Uses `wsgi_dss.py` for production WSGI configuration
  - No CORS required (same-origin deployment)
  - Automatic environment detection via Dataiku environment variables

**Local Development**:

- **Frontend**: Vite dev server with hot module replacement for fast development cycles
  - Configurable port (default: `5173`)
  - Proxy configuration for seamless API communication
  - Real-time code reloading and debugging tools

- **Backend**: Standalone Flask server with development features
  - Configurable API port (default: `5000`)
  - CORS enabled for cross-origin requests
  - Debug mode for detailed error information

- **Environment**: Uses environment variables for port configuration and API endpoints