The webapp provides a clean, intuitive interface for interacting with the Agentic Insights analysis system. It features a sidebar-based navigation layout with two main functional areas: launching new analyses and exploring historical results. The interface is designed to guide users through the analysis workflow, from parameter configuration to report interpretation, with integrated AI assistance for enhanced understanding of analysis findings.

The user interface emphasizes simplicity and efficiency, with collapsible sections, real-time status updates, and seamless integration of the Report Assistant Agent for contextual help and insights.

<br>

## Webapp Layout
---

The webapp features a clean, sidebar-based navigation layout with two main tabs:

- **Sidebar Navigation**: Fixed sidebar on the left with menu items to switch between tabs
- **Main Content Area**: Dynamic content area that displays the selected tab's interface
- **Responsive Design**: Modern UI built with Tailwind CSS and shadcn-vue components


![webapp_overview.png](ILmxoKLCOFRc)



<br>

### 1. Tab 1: New Analysis
---

The "New Analysis" tab allows users to configure and launch new analysis sessions. It consists of three main sections displayed vertically:

<br>

#### 1.1 Session Parameters

A collapsible card section where users configure all analysis session parameters:


**Required Parameters:**
- **Input Dataset**: Dropdown selector to choose the dataset for analysis (required)
  - Options are loaded from the "Input Datasets" Flow Zone
  - Automatically loads dataset columns when a dataset is selected

![webapp_tab1_session_params_required.png](8nRf9fNF10co)


<br>

**Optional Parameters** (collapsible section):



![webapp_tab1_session_params_optional.png](JCv8Wk9CQyvU)



- **Analysis To Perform**: Multi-select interface for choosing analytic tools
  - Expandable list showing all available analysis types
  - Checkbox-based selection with visual feedback
  - Selected analyses displayed as removable tags
  - Options loaded from the `analytic_tools` dataset
  - All analyses selected by default

- **Target Variable Configuration** (shown only when Root Cause Analysis is selected):
  - **Infer Target Variable**: Toggle switch to automatically infer the target variable
  - **Manual Target Column**: Dropdown to manually select target column (shown when inference is disabled)
  - Column options are dynamically loaded based on selected dataset

- **Internal Business Rules**: 
  - Toggle switch to enable/disable business rules usage
  - "Open Dataset" button to view the business rules dataset in a new tab (when enabled)

- **Additional Analysis Context**: 
  - Text area for providing additional context, requirements, or instructions for the analysis

<br>

**Features:**
- Collapsible sections for better organization
- Real-time validation of required fields
- Dynamic column loading based on dataset selection
- Visual feedback for selected options

<br>

#### 1.2 Analysis Trigger

A card section containing the analysis launch controls:



![webapp_tab1_session_trigger.png](uJjhuxEG9C2c)
![webapp_tab1_session_trigger_running.png](e0CVs5j60Jh5)


**Components:**
- **Launch Analysis Button**: 
  - Primary action button to start the analysis
  - Validates required parameters before launching
  - Disabled during execution

- **Abort Button**: 
  - Appears when analysis is running
  - Allows users to stop the current analysis session
  - Requires confirmation before aborting

- **Last Launch Information**: 
  - Displays the timestamp of the last launched analysis
  - Shows the status of the last run (completed, running, failed, etc.)

<br>

**Functionality:**
- Automatic status polling during analysis execution
- Real-time status updates from the backend
- Session ID generation before launch
- Error handling with user-friendly messages

<br>

#### 1.3 Report

A collapsible section that displays analysis results and provides AI assistance:

##### 1.3.1 Report Viewer

**Purpose**: Displays the generated HTML analysis report in an embedded iframe.


![webapp_tab1_report.png](X7CsGWVb8G9M)



**Features:**
- **Auto-Open**: Automatically expands when analysis completes and report is available
- **Loading State**: Shows "Loading report..." message while report is being generated
- **Empty State**: Displays message when no report is available
- **Full Report Display**: Renders complete HTML report with embedded visualizations, charts, and insights
- **Responsive Layout**: Adjusts width based on AI Assistant visibility (70% when assistant enabled, 100% when disabled)

**Report Content:**
- Executive summary and key findings
- Technical analysis results
- Interactive visualizations
- KPIs and metrics
- Recommended actions

<br>

##### 1.3.2 AI Assistant

**Purpose**: Provides an interactive AI assistant powered by the Report Assistant Agent to help users understand and explore analysis reports.


![webapp_tab1_report_with_assistant.png](tZlNgQzlEFcO)


**Features:**
- **Toggle Control**: Switch to enable/disable the AI Assistant
- **Iframe Integration**: Embedded Report Assistant Agent webapp via iframe
- **Dynamic URL**: Automatically fetches the correct webapp path from the backend
- **Refresh Capability**: Can be refreshed when viewing different reports
- **Side-by-Side Layout**: Displays alongside the report viewer (30% width when enabled)

**Functionality:**
- Users can ask questions about the analysis report
- Agent provides contextual answers based on the report content
- Helps users understand findings and explore data insights
- Accessible through Agent Hub's unified chat interface

<br>

### 2. Tab 2: Historical Analysis
---

The "Historical Analysis" tab allows users to view, manage, and interact with past analysis sessions. It consists of two main sections:

<br>

#### 2.1 Historical Analysis Sessions

A comprehensive table displaying all past analysis sessions with detailed metadata:


![webapp_tab2_table.png](PCKqtw3nadFt)


**Table Columns:**
- **Selection Checkbox**: Allows bulk selection of sessions for deletion
- **Actions**: 
  - **View Button**: Opens the report for the selected session
  - **Delete Button**: Deletes individual sessions (with confirmation)
- **Analysis Session ID**: Unique identifier for each session
- **Input Dataset**: Dataset used for the analysis
- **Analysis To Perform**: List of analytic tools executed (displayed as badges)
- **Infer Target Column for RCA**: Boolean indicator (Yes/No badge)
- **Target Column for RCA**: Manual target column if specified
- **Use Business Rules**: Boolean indicator (Yes/No badge)
- **Additional Context**: User-provided context text (truncated if long)
- **Start Datetime**: When the analysis started (formatted)
- **End Datetime**: When the analysis completed (formatted)
- **Status**: Current status with color-coded badges:
  - **Completed/Success**: Green badge
  - **Running/Warning**: Yellow badge
  - **Failed/Aborted**: Red/Orange badge

<br>

**Features:**
- **Sorting**: Sessions sorted by start datetime (most recent first)
- **Bulk Delete**: Delete multiple selected sessions at once
- **Scrollable Table**: Scrollable area for large session lists
- **Session Count**: Displays total number of sessions found
- **Auto-Refresh**: Automatically refreshes session list periodically (every 10 seconds)


![webapp_tab2_table_bulk_delete.png](LD6so62qg6V9)


<br>

**Actions:**
- **View Session**: 
  - Updates analysis session parameters in the flow
  - Loads and displays the report for the selected session
  - Refreshes AI Assistant to match the selected report
  
- **Delete Session(s)**: 
  - Confirmation dialog before deletion
  - Removes session from history
  - Clears displayed report if deleted session was selected
  - Refreshes session list after deletion

<br>

#### 2.2 Report

Same report section as in "New Analysis" tab, but displays reports from historical sessions:


##### 2.2.1 Report Viewer


**Purpose**: Displays historical analysis reports when a session is selected from the table.

**Features:**
- **On-Demand Loading**: Report loads when user clicks "View" on a session
- **Loading State**: Shows loading indicator while fetching report
- **Report Display**: Same iframe-based display as new analysis reports
- **Session Context**: Automatically updates flow parameters before loading report

<br>

##### 2.2.2 AI Assistant

**Purpose**: Provides AI assistance for historical reports, with context matching the selected session.

**Features:**
- **Session-Specific Context**: Refreshes when viewing different historical sessions
- **Same Functionality**: All features from the "New Analysis" AI Assistant
- **Dynamic Refresh**: Iframe key updates to ensure fresh context for each session
