This document provides a comprehensive overview of all components in the Agentic Insights solution. It describes the architecture, key components, data flow, and how they work together to deliver automated data analysis capabilities.

The solution consists of four main pillars: the **Webapp** (user interface and backend), the **Agentic Framework** (AI agents and orchestration), **Flow Zones** (project organization), and **Scenarios** (workflow automation). Each component plays a specific role in the end-to-end analysis workflow.

<br>

## Webapp
---

The webapp is the main entry point and central hub of the Agentic Insights solution. It provides the user interface for launching analyses, monitoring execution, and exploring results.

![agentic_insights_homepage.png](uOxsIPIsAumn)


<br>

## Agentic Framework
---

The Agentic Framework is the core AI infrastructure that orchestrates automated analysis workflows. It consists of specialized Dataiku Visual Agents and orchestration components.

- **Main Agent** (`va_main_agent`): The primary AI agent responsible for orchestrating the entire analysis workflow. Acts as a seasoned Data Analyst that receives user requirements, explores datasets, applies business rules, executes analytic tools (clustering, outlier detection, forecasting, root cause analysis), and generates comprehensive HTML reports with 8 specialized tools.

- **Report Assistant Agent** (`va_report_assistant`): A specialized AI agent designed to assist users in exploring and interpreting analysis reports. Provides contextual help, explains report content, explores underlying data, and suggests follow-up explorations with 6 specialized tools. Embedded in webapp via Agent Hub's unified chat interface.

- **Agent Hub**: The connection and interaction layer that provides a simple and intuitive chatbot interface for the Report Assistant Agent. Connects to the existing agent, configures user interaction, sets up default questions, and enables seamless iframe integration in the webapp.

- **Prompt Recipe**: The orchestration layer in the Analysis Session Flow Zone that triggers the Main Agent workflow and retrieves analysis results. Receives session parameters from webapp and acts as the bridge between webapp requests and agent execution.

<br>

## Flow Zones
---

Flow Zones organize the project structure into logical sections for different components and purposes.

- **Input Datasets Flow Zone**: Repository for input datasets available for analysis. All datasets in this zone appear in the webapp's dataset dropdown and can be selected for analysis sessions.

- **Administration Flow Zone**: Contains critical system configuration including the `analytic_tools` dataset (catalog of available analytic tools) and `business_rules` dataset (organizational policies and constraints).

- **AI Agents Flow Zone**: Contains the AI agents responsible for orchestrating analysis workflows and providing user assistance, including Main Agent (`va_main_agent`) and Report Assistant Agent (`va_report_assistant`).

- **Analysis Session Flow Zone**: Orchestration layer containing the main Prompt Recipe that receives session parameters from the webapp, queries the Main Agent, and manages the connection between webapp and agent execution.

- **Analysis Outputs Flow Zone**: Stores all outputs generated by analysis sessions, including the `analysis_reports` folder (HTML reports) and `analysis_session_history` folder (session metadata).

- **Dynamic Analysis Session Flow Zones** (`analysis_session_{random_id}`): Dynamic workspaces created automatically for each analysis session, containing the complete flow generated by the agent (recipes, datasets, models). Each zone is isolated and tagged for identification and management.

<br>

## Scenarios
---

Dataiku scenarios provide execution tracking, security, and monitoring for the analysis workflow.

- **Main Analysis Session Scenario** (`main_analysis_session_scenario`): Triggered automatically by the webapp to execute the main Prompt Recipe and orchestrate the complete analysis workflow from session initialization to report generation
- **Delete Analysis History Scenario** (`delete_analysis_history`): Manual administrative tool for cleaning up old analysis flow zones, keeping only the N most recent ones based on creation date


<br>


## Best Practices
---

### Configuration

- Keep `analytic_tools` dataset up-to-date with available capabilities
- Maintain active business rules in `business_rules` dataset
- Ensure input datasets are properly formatted and ready for analysis

<br>

### Usage

- Start with default parameters to understand system behavior
- Enable business rules to ensure organizational compliance
- Leverage AI Assistant to deepen understanding of analysis results
- Review historical sessions to track trends and patterns

<br>

### Management

- Regularly clean up old analysis session flow zones
- Monitor storage usage for reports and metadata folders
- Review generated flows to understand agent behavior
- Use session metadata for troubleshooting and optimization
