import dataiku
from dataiku.llm.agent_tools import BaseAgentTool

from agentic_insights.backend.agentic_insights_toolkit.dku_utils.object import get_or_create_flow_zone
from agentic_insights.backend.agentic_insights_toolkit.dku_utils.utils import get_zone_flow



class MyAgentTool(BaseAgentTool):
    """An empty interface for a code-based agent tool"""

    def __init__(self):
        pass

    def get_descriptor(self, tool):
        """
        Returns the descriptor of the tool, as a dict containing:
           - description (str)
           - inputSchema (dict, a JSON Schema representation)
        """
        return {
            "description": "Retrieve the Flow items associated with a given analysis_session_b714a2dc.",
            "inputSchema" : {
                "$id": "autoinsight_analysis_flow_retriever",
                "title": "Auto-Insight Analysis Flow Retriever",
                "type": "object",
                "properties": {
                    "analysis_session_id": {
                        "type": "str",
                        "description": "The ID of the analysis associated with this report."
                    },
                },
                "required": ["analysis_session_id"]
            }
        }


    def invoke(self, input, trace):
        """
        Invokes the tool.

        The arguments of the tool invocation are in input["input"], a dict
        """
        output = ""
        try:
            analysis_session_id = input["input"]['analysis_session_id']
            zone = get_or_create_flow_zone(flow_zone_name = analysis_session_id)
            analysis_flow = get_zone_flow(zone)
            output = str(analysis_flow)
        except Exception as e:
            output = f"❌ Failed to retrieve analysis flow: {e}"
        
        return {
            "output": output,
            "sources": [],
        }
