import dataiku
from dataiku.llm.agent_tools import BaseAgentTool

from agentic_insights.backend.agentic_insights_toolkit.agent.report_utils import generate_full_report
from agentic_insights.backend.agentic_insights_toolkit.adm.common import get_analysis_report_folder
from agentic_insights.backend.agentic_insights_toolkit.dku_utils.utils import write_text_to_folder

class MyAgentTool(BaseAgentTool):
    """An empty interface for a code-based agent tool"""

    def __init__(self):
        pass

    def get_descriptor(self, tool):
        """
        Returns the descriptor of the tool, as a dict containing:
           - description (str)
           - inputSchema (dict, a JSON Schema representation)
        """
        return {
            "description": "Saves the output report to a file inside a DSS folder.",
            "inputSchema" : {
                "$id": "generate_full_report",
                "title": "Full Report Generator",
                "type": "object",
                "properties": {
                    "analysis_session_id": {
                        "type": "str",
                        "description": "Unique identifier of the analysis session."
                    },
                    "report_data": {
                        "type": "str",
                        "description": "The content of report_data that respects provided template. This will merge into the final report."
                    }
                },
                "required": ["analysis_session_id", "report_data"]
            }
        }


    def invoke(self, input, trace):
        """
        Invokes the tool.

        The arguments of the tool invocation are in input["input"], a dict
        """
        tool_input = input["input"]
        
        analysis_session_id = (tool_input.get("analysis_session_id", "unknown_analysis")).strip()
        report_data = tool_input.get("report_data")
        
        full_report = generate_full_report(
            analysis_session_id = analysis_session_id,
            report_data = report_data
        )
        

        output = ""
        try:
            file_name = (tool_input.get("analysis_session_id", "unknown_analysis")).strip()
            if not file_name.endswith(".html"):
                file_name += ".html"
                
            final_file_name = file_name
            #timestamp = datetime.now().strftime("%Y%m%d_%H%M%S")
            #final_file_name = f"[{timestamp}]{file_name}"
            report_folder = get_analysis_report_folder()
            write_text_to_folder(
                text=full_report,
                folder=report_folder,
                file_path=final_file_name
            )

            output = f"✅ Insight report written successfully to '{final_file_name}'"
        except Exception as e:
            output = f"❌ Failed to save insight report: {e}"

        return {
            "output": output,
            "sources": [],
        }
