import dataiku
from dataiku.llm.agent_tools import BaseAgentTool

from agentic_insights.backend.agentic_insights_toolkit.dku_utils.utils import get_project_variables



class MyAgentTool(BaseAgentTool):
    """An empty interface for a code-based agent tool"""

    def __init__(self):
        pass

    def get_descriptor(self, tool):
        """
        Returns the descriptor of the tool, as a dict containing:
           - description (str)
           - inputSchema (dict, a JSON Schema representation)
        """
        return {
            "description": "Retrieve the analysis session parameters associated with the selected report.",
            "inputSchema" : {
                "$id": "analysis_session_params_retriever",
                "title": "Analysis Session Params Retriever",
                "type": "object",
                "properties": {},
                "required": []
            }
        }


    def invoke(self, input, trace):
        """
        Invokes the tool.

        The arguments of the tool invocation are in input["input"], a dict
        """
        # Retrieve local project variables
        local_vars = get_project_variables("local")
        selected_analysis_session_id = local_vars.get("SELECTED_ANALYSIS_SESSION_ID")

        if not selected_analysis_session_id:
            return {
                "output": (
                    "No selected_analysis_session_id found in local project variables. "
                    "Make sure an analysis session/report is selected before calling this tool."
                ),
                "sources": [],
            }


        return {
            "output": (
                "Analysis Session parameters: "
                f"selected_analysis_session_id='{selected_analysis_session_id}'"
            ),
            "sources": [],
        }
