import axios from "./api/index"

export interface StartAnalysisSessionData {
    analysis_session_id: string
    input_datasets?: string[]
    analysis_to_perform?: string[]
    infer_target_variable?: boolean
    additional_context?: string
    manual_target_col_for_rca?: string
    report_template_id?: string
    start_datetime?: string
    end_datetime?: string
}

export interface ScenarioRunInsights {
    run_id: string
    status: string
    start_dt_utc: string
    end_dt_utc: string
    duration: number
    trigger_type: string
}

export interface StartAnalysisSessionResponse {
    ok: boolean
    scenario_run_insights?: ScenarioRunInsights
    error?: string
}

export const API = {
    getAnalysisSessions: () => axios.get('/api/get-all-analysis-session-metadata'),
    getAllAnalysisTypes: () => axios.get('/api/get-all-analysis-types'),
    getAllInputDatasets: () => axios.get('/api/get-all-input-datasets'),
    getAllReportTemplates: () => axios.get('/api/get-all-report-templates'),
    getDatasetColumns: (datasetName: string) => axios.get('/api/get-dataset-columns', {
        params: { dataset_name: datasetName }
    }),
    generateAnalysisSessionId: () => axios.get('/api/generate-analysis-session-id'),
    startAnalysisSession: (data: StartAnalysisSessionData) => axios.post<StartAnalysisSessionResponse>('/api/start-analysis-session', data),
    getAnalysisReport: (analysisSessionId: string) => axios.get('/api/get-analysis-report', {
        params: { analysis_session_id: analysisSessionId }
    }),
    deleteAnalysisSession: (analysisSessionId: string) => axios.post('/api/delete-analysis-session', {
        analysis_session_id: analysisSessionId
    }),
    getLastAnalysisRunStatus: () => axios.get('/api/get-last-analysis-run-status'),
    abortAnalysisSession: () => axios.post('/api/abort-analysis-session', {}),
    updateAnalysisSessionParamsInFlow: (analysisSessionId: string) => axios.post('/api/update-analysis-session-params-in-flow', {
        analysis_session_id: analysisSessionId
    }),
    getReportAssistantWebappPath: () => axios.get('/api/get-report-assistant-webapp-path')
}

export default API