The last zone of the project is the [Model Drift zone](flow_zone:fnfkS9B). It is in charge of monitoring the performance of the model over time and checking that the data has not drifted too much.
 
![Model Drift.png](ma39BiHoqxwV)
 
# Model Drift
 
The central part of the zone that relies on the dataset [alerts_test](dataset:alerts_test) computes the performance metrics of the model on some unseen data. This data is made of the last 4 weeks of alerts and has not been used in the model training. As time goes by, the model will become more and more outdated with regards to the updated test data. The [evaluate recipe](recipe:evaluate_on_transactions_test) computes all the standard metrics to evaluate the performance of a binary classification model. The following [prepare recipe](recipe:compute_metrics_prepared)  removes some metrics and creates the ones that are most relevant to the business, namely the false positive rate and the false negative rate.
 
The two subsequent recipes pick the oldest and the most recent evaluations and then compute the difference between them for each of these values. Some triggers can be added when performance metrics drift too far way from their initial point. A [join](recipe:compute_metrics_compared) also compares the performance metrics from the rules-based prioritization with the ML-based prioritization.
 
# Data Drift
 
In the upper part of the flow zone takes place the data drift analysis. First, the [validation dataset](dataset:alerts_validation) is created in the same way as in the model. Then the [evaluate recipe](recipe:evaluate_on_alerts_validation) computes the performance and drift between the validation dataset used for the training at the moment when the model was deployed and the most recent validation dataset. So at the first iteration, there is no data drift because the two datasets are identical, the drift score is under 0.5. Then as data drifts over time, the drift model accuracy increases, meaning that it is getting easier to discriminate between the two datasets. When the drift exceeds 0.5, the user should start worrying about the drift and consider training again with fresher data.
 

