# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu
from commons.python.dku_utils.core import get_current_project_and_variables
from datetime import datetime

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# Read recipe inputs
batch_and_sensor_last = dataiku.Dataset("batch_and_sensor_last")
batch_and_sensor_last_df = batch_and_sensor_last.get_dataframe()

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
project, variables = get_current_project_and_variables()
variables_dict = dict(zip(variables["standard"]["attribute_names"], variables["standard"]["attribute_prediction"]))
variables_dict.pop('equipment_id', None)

data_for_prediction_df = batch_and_sensor_last_df

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# rename the columns to match what the model expects
renaming = {}
for col in data_for_prediction_df.columns:
    renaming[col] = "%s_first"%col

renaming.pop('equipment_id', None)
data_for_prediction_df.rename(columns=renaming, inplace=True)

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# add the selected attributes for the prediction
data_for_prediction_df["batch_id_last"] = "None"
data_for_prediction_df["start_time_last"] = datetime.now()

for key in variables_dict.keys():
    data_for_prediction_df["%s_last"%key] = variables_dict[key]

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# Write recipe outputs
data_for_prediction = dataiku.Dataset("data_for_prediction")
data_for_prediction.write_with_schema(data_for_prediction_df)