## User Story
 **A Relationship Manager's Story** 
 
Relationship Managers often know their clients well; welcoming them during onboarding, maintaining regular contact, and noting personal milestones. Yet many still face a troubling reality: customers silently disengage.

There are no complaints or closure requests. Just gradual inactivity; unused credit cards, stagnant balances, no logins. By the time it’s noticed, the customer is already gone.

- What Relationship Managers need is foresight, not hindsight

- Who is showing early signs of disengagement?

- Which product is the trigger?

- Is this temporary, or the start of attrition.

 **They don’t just need a list of customers, they need context: why someone is at risk, what’s changing, and when to act. This solution provides that missing visibility.** 
 
## Data

This article goes through all the steps, from data input to obtaining the final analyses. It starts with five already prepared datasets covering 16 months of historical banking data that include:
 - A revenue dataset of more than 600k rows.
 - A balance dataset of more than 400k rows.
 - A product holdings dataset of more than 50k rows including 4 distinct product types and 10 distinct products.
 - A customer dataset of around 22k distinct customers.
 - An additional information dataset of more than 300k rows.
 
 - **Input Data**: Customer–product level records are aggregated to monthly level, aligned with the expected [Data Model](article:7), which describes the necessary format criteria to be met.
 - **Prep in Dataiku**: Load the datasets into the churn project and parse the month aggregated column as a date. When joining with revenue, balance, or product holdings datasets, ensure column naming consistency with the expected [Data Model](article:7)
 
 
## Insights

This Solution provides a customizable churn prediction framework to detect early signs of disengagement; both at the  **Customer level ** and the ** Product level** , leveraging a ML model.

It supports:

 **[Customer Level Churn Analysis](dashboard:WakSLY7):**  Identifies customers likely to exit the complete relationship with the company entirely by aggregating churn across all products.

 **[Product Level Churn Analysis](dashboard:5TpFFXE):**  Highlights drop-offs from specific products to inform targeted, product-wise interventions.

- Designed as a template-based solution, it allows to prepare your own data externally, making sure the column names and types for mandatory columns are same as in the data model and plug it into the pipeline. 

- Users can adapt the solution end-to-end or selectively reuse components for labeling, feature engineering, modeling, or visualization, based on their unique data models and objectives.

## Adapt to Telecom/Insurance/subscription based datasets

The churn Prediction solution is data-model agnostic: everything is built around a simple, universal structure:  customer_id, product, date, with linked tables for revenue, balances, product holdings, and customer attributes.

- We use Dataiku recipes like Window, Group, and Prepare to aggregate data into monthly snapshots, generate features on activity trends, balances, and revenues, and can apply flexible churn labeling rules (no revenue, closure in the churn window or zero balances).

Because the logic is generic i.e. “ **customer + product + time** ” the framework can be adapted, for example, like below:

- ** In Telecom** :  product = plan or service (mobile plan/broadbank package/ Internet service/ OTT partnership), revenue = Monthly bills/Average Revenue per User , balance = prepaid balance amount/unpaid bills, Tier = Plan (prepaid/ postpaid/ premium)/ ARPU brackets/ data-speed packages

- ** In Insurance** :  product = policy, revenue = premiums, balance = claims/cash value/reserve, Tier= Policy Tier (Basic/comprehensive/premium)

-  **In Subscription businesses**  (OTT, SaaS, retail memberships): where product  = subscription, revenue = fees, Tier= Basic/plus/Elite/Silver/Gold/Platinum,  optional = logins or consumption.

The recipes and pipelines don’t change; only the data mapping and churn definition parameters shift as per business requirments, making this a churn engine across industries.

