Scored holdout datasets are evaluated through a series of metrics and compared with graphs. These datasets have not been used in the training but left aside for scoring and evaluation.

![Model Comparison.png](GoFPVPIkWjsk)

# Preparation

First, the three scored datasets are joined on the id key they all share. We keep a copy of the features so that a reader can have a sense of what kind of policyholder each row corresponds to.

Then, in the following prepare recipe, the Compound Model prediction is simply computed as the product of the Claim Number prediction and the Claim Amount prediction. This will be the prediction that is comparable with the Tweedie Prediction.

# Metric Computation

A first [python recipe](recipe:compute_regression_fit) computes the fit using parametric measures including:
- Tweedie deviance on a range of variance power values between 1 and 2.
- Root Mean Square Error
- Mean Absolute Error

For all these metrics, the Compound model performs better than the Tweedie model. It makes sense as this model can more finely capture effects distinct for Claim Frequency and Claim Severity. However working a bit more on the feature handling might product different results.

A second [python recipe](recipe:compute_lorenz_graph) computes the [lorenz curves](https://en.wikipedia.org/wiki/Lorenz_curve) for the two models along with the random and the oracle model. The random model draws a line close to the diagonal whereas the oracle model is as close as it can get of the bottom and right axis (it has the smallest area under curve). The gini coefficient is [computed](recipe:compute_aucs) as:

```gini = 1 - 2 * auc(lorenz)```

Where auc stands for area under curve. This metric leads to the same conclusion about performance between the two models, with the Compound Model having a higher gini coefficient, thus performing better. We can also see on the lorenz curve that the Compound Model curve is nearly always under the Tweedie Model curve.

[Avg. of random_cum_claim_amount by cum_samples on lorenz_curves](insight:ZYKZktD)