In this slide, we compare a few performance metrics between the Compound Model and the Tweedie Model. The computation of the metrics is explained in this [article](article:19).

First, we compute tweedie variance for multiple values of variance power between 1 and 2, as well as root mean square error and absolute mean error. To have them all on the same graph, mean absolute error is assigned the variance power of 1 and root mean square error the variance power of 0.5. Since the latter's order of magnitude shrinks all the others we ultimately filter it out of the graph. With the current models, the Compound Model outperforms the Tweedie model for all evaluation metrics.

![tweedie variance.png](EadEQtNlCWfl)

The lorenz curve is represented for both models, and also for a random and oracle model. The lorenz curve is built as a cumulative claims plot. Real claims are ranked by order of risk according to each model and the y-axis represents the share of cumulated claims by quantile. The random model is built using random values and consists of a straight diagonal line. The oracle model is built using the real data as a ranking and yields the curve the closest to the bottom left corner (because it starts accumulating all the claims with 0 risk which represent most of the data before accumulating the risky ones). The Compound Model is always under the Tweedie Model and so it performs better for that metric.

![lorenz curve.png](eO03wQgfM5e4)

The gini coefficient gives a numerical measure based on the lorenz curve. It is computed as ```1 - 2 * auc(lorenz curve)```. The higher the gini coefficient the better, and once again the Compound Model has the best performance. This metric does not assess goodness-of-fit as it does not compare absolute prediction values but only their relative values. A model could therefore have a close-to-perfect gini coefficient but predictions that are not reasonable. It should therefore be combined with other evaluation metrics to make sure predictions are not biased, unless we are only interested in relative predictions and ranking policyholders according to their risk.

![ginis.png](Nr8WT6V3a9Ek)
