# Pushing the Models to Production

Dataiku is an end-to-end platform which enables users to start up their projects from data connection, data preparation and experimentation to actual production. In particular for Claims models, the output is not only a series of graphs, or a formulation that has to be exported in a separate tool to be useful, but a rating engine that will produce pricings for user-defined parameters.

In Dataiku, once a model is satisfactory, it can be deployed on the flow. Deployed models are then used to score new data, either holdout data for performance assessment, or batches of unlabelled data that is being scored together. [Scenarios](https://doc.dataiku.com/dss/latest/scenarios/index.html) enable to automate the scoring of batch data.

To consume the model prediction in real-time, deployed models can also be exposed on an [API](https://doc.dataiku.com/dss/latest/apinode/index.html). If an API node is already setup, it is only a matter of a few clicks to have a model that can be called with an http request. To consume the model, a user would have to send the request in a json with the required parameters, and will receive back the prediction.

A simple webapp can make the requests to the API, and the user would only need to input the parameters in an interactive way. This was implemented in the current solution, with a dash webapp to compare dynamically results from the two approaches that were chosen. 

# What's next

GLM outputs are not the final price that will be quoted to a customer. They correspond to the expected loss from a client, therefore the price paid by the customer should be higher to at least cover its risk. The layer that takes as input the GLM and outputs the quoted price is called price optimization.

Among the elements that may affect the price are:
- Price Elasticity: how sensitive is the customer to price variation
- Churn Risk: is the customer at risk of changing insurance provider
- Competition: how competitive is the market on the customer's segment
- Customer Lifetime Value: how valuable might this customer become

These further analyses and optimization can be carried out in separate subsequent projects, in Dataiku or using other tools.