請求の重大度は[請求頻度](article:16) のモデリングと同様に、GLM を使用してモデル化されます。ただし、相違点がいくつかあり、それらについてはこの記事で取り上げています。

![Claim Severity Modeling.png](xfGxoBrLfVzN)

# 入力データセット

請求程度とは、請求の金額を分析したものであり、請求の存在が条件となります。したがって、まずデータセットをフィルターして、ClaimNb が 0 より大きい観測結果のみを含めます。

このスコアリングでは、ClaimAmount 予測の計算に ClaimNb 予測も使用します。そのため、まず請求頻度モデルで claim_test データセットをスコアリングしてから claim_test に戻し、スコアリング対象のデータセットを作成する必要があります。

# モデリング

スクリプトは[請求頻度](article:16)のものと同じです。ここでは ClaimAmount を予測します。ClaimAmount はガンマ分布に従う可能性が高く、メトリクスは異なるものになります。ここではガンマ偏差を監視します。変数と前処理の選択は、請求頻度で選択されたものとは多少異なります。これは、両ターゲットの依存関係が同一ではないからです。これについては、 [ダッシュボードの記事](article:10)で詳しく説明します。

ClaimAmount は、次のパラメーターを使用して GLM でモデル化されます。
- Elastic Net Penalty（エラスティックネットのペナルティ）: 0
- Distribution（分布）: Gamma
- Link function（リンク関数）: Log
- Offset mode（オフセットモード）: Offsets/Exposures
- Training dataset（トレーニングデータセット）: claim_severity_analysis
- Offset columns（オフセット列）: None
- Exposure columns（エクスポージャー列）: ClaimNb, here claim amounts are normalized by claim number instead of exposure because in the end, we want to model the amount per claim.