スコアリング済みの提供されたデータセットは、一連のメトリクスを通じて評価され、グラフで比較されます。これらのデータセットはトレーニングでは使用されず、スコアリングと評価のために残されていたものです。

![Model Comparison.png](GoFPVPIkWjsk)

# 準備

最初に、スコアリングされた 3 つのデータセットは、全員が共有する ID キーで結合されます。特徴量のコピーを保持することで、各行がどのような保険契約者と対応しているかをデータ利用者が理解できるようにします。

その後の準備レシピでは、請求数予測と請求金額予測の積により、複合モデル予測が算出されます。これは Tweedie 予測と同等の予測となります。

# メトリクス計算

最初の [Python レシピ](recipe:compute_regression_fit) は、次のようなパラメトリック測定を使用して適合度を計算します。
- 1～2 の範囲の分散パワー値をとる Tweedie 偏差
- Root Mean Square Error（二乗平均平方根誤差）
- Mean Absolute Error（平均絶対誤差）

これらすべてのメトリクスについて、複合モデルのパフォーマンスは Tweedie モデルのものよりも優れています。このモデルでは、請求頻度と請求程度についてより細かく影響を把握できるため、理にかなっています。ただし、特徴量の処理についてもう少し詳しく検討すると、異なる結果が生じる場合があります。

2 つ目の [Python レシピ](recipe:compute_lorenz_graph) は、上記 2 つのモデルとランダムモデルおよび Oracle モデルの [ローレンツ曲線](https://ja.wikipedia.org/wiki/%E3%83%AD%E3%83%BC%E3%83%AC%E3%83%B3%E3%83%84%E6%9B%B2%E7%B7%9A) を計算します。ランダムモデルでは対角線に近い線が描画されますが、Oracle モデルでは下部と右軸に非常に接近した線が描画されます（曲線の下の領域が最も小さい）。ジニ係数は次のように [計算](recipe:compute_aucs) されます。

```gini = 1 - 2 * auc(lorenz)```

ここで、auc は曲線の下の領域を表します。このメトリクスでも、2 つのモデルのパフォーマンスについて同じ結論に達しています（複合モデルのジニ係数のほうが大きく、より優れたパフォーマンスを示している）。また、ローレンツ曲線では、複合モデルの曲線はほぼ常に Tweedie モデル曲線の下に位置していることもわかります。

[lorenz_curves に基づく cum_samples ごとの random_cum_claim_amount の平均](insight:ZYKZktD)