# モデルを本番環境にデプロイ

Dataiku は、データ接続、データ準備、実験から実際の運用まで、ユーザーのプロジェクト開始を実現するエンドツーエンドのプラットフォームです。とくに請求モデルの場合、出力には、一連のグラフや、別のツールへエクスポートして利用する必要のある式だけではなく、ユーザー定義パラメーターに対して価格を生成する評価エンジンも含まれます。

Dataiku では、モデルが満足できるものになったら、フローにデプロイできます。デプロイしたモデルは、新しいデータ（パフォーマンス評価のために提供されたデータ、または一緒にスコアリングされる、ラベルの付いていないバッチデータ）のスコアリングに使用されます。[シナリオ](https://doc.dataiku.com/dss/latest/scenarios/index.html) を使用すると、バッチデータのスコアリングを自動化できます。

モデル予測をリアルタイムで使用するために、デプロイされたモデルを [API](https://doc.dataiku.com/dss/latest/apinode/index.html)上で公開することもできます。すでにAPIノードが設定されている場合は、数クリックでhttpリクエストで呼び出せるモデルが完成します。モデルを使用するには、必要なパラメーターを含むリクエストを json で送信し、予測を受け取ります。

シンプルな Web アプリは API に要求を行うことができ、ユーザーはインタラクティブにパラメーターを入力するだけです。これは現在のソリューションに導入されており、Dash Web アプリを使用すると、選択した 2 つのアプローチの結果を動的に比較できます。

# 次のステップ

GLM 出力は、顧客に提供する最終見積価格ではありません。GLM 出力は顧客からの期待損失に対応しているため、顧客から支払われる価格は、少なくともそのリスクをカバーするためにより高い金額でなければなりません。GLM を入力として使用し、見積価格を出力として使用するレイヤーは、価格最適化と呼ばれます。

価格に影響を及ぼす要素には次のものがあります。
- 価格弾力性：顧客が価格変動に対してどれだけ敏感であるか
- チャーン（離反）リスク：保険会社を変更するリスクがある顧客
- 競合他社：その顧客のセグメントにおける市場の競争力
- 顧客の生涯価値：この顧客からどの程度の価値を得られるか

これらの詳細な分析と最適化は、Dataiku やその他のツールを使用して、別個のプロジェクトで実施できます。