This Solution has two main components: Project Setup and Agent Hub Webapp. The project setup configures the project connections and options to import insights from other Dataiku Business Solutions. The Agent Hub Webapp hosts the Clinical Trial Intelligence Assistant, where users can interact. 

# Project Setup
To configure and execute the GenAI pipeline that powers the agent system. Please read [Project Setup](article:9)

## Connection configuration
Users should select the connections for the project datasets and the models driving the agents. The agentic system requires an SQL connection for its SQL query tool, a stronger model for planning and reasoning, a simpler model for basic tasks, and an embedding model for vectorization tasks. 
![projectsetup-connection.png](wpAr96vxlLde)

## Import Solution insights (optional)
Select the project or the Dataiku application instance for the Clinical Site Intelligence Solution and Social Determinants of Health Solution, then select the required dataset for each input.
![projectsetup-import-solutions-expend.png](BDoeFe339ItV)

## Build the pipeline
Click on the "Build Flow" button to create the pipeline.

# Additional Configuration
## Email Connection 
The agent requires an STMP channel. Users can create the channel in  **Administration**  >  **Notifications & Integrations**  >   **Salesforce login with Username-Password** >  **Messaging channels** >**Mail (SMTP) channel**. 

To generate a  **password**  to sign in within the Mail (SMTP) channel, use this [link](https://support.google.com/mail/answer/185833?hl=en). 

## Send message tool config
Select the corresponding mail channel for the agent tool [Sent Draft by Email](agent_tool:rTWyMmL)

# Launch Agent Hub
Once the pipeline is built, click the "Clinical Trial Intelligence Assistant" button to access the web app and interact with the agent.

## Start a Conversation
Start a new conversation by including the two enterprise agents, [Study Information Retrieval Agent](saved_model:avY3Auys) and [Trial Alignment Report Agent](saved_model:az5X4MFP). 
![Adobe Express - agenthub-start-conversation.gif](1BOZKitbcFzw)

## Trace the Agent Activities
Click on "See details" to trace the agents' activities for each response. It reveals the agent's reasoning process and the raw data it retrieved for a given task. 
![Adobe Express - agenthub-agent-activities.gif](yl8ovkJ5cwUi)


Visualize the agent activity log by Trace Explorer
![agenthub-details.png](hKYMDeLJHp2j)


# The Agent in Action: A Clinical Site Planning Scenario

## Use Case 1: Study Comparison
- Goal: Understand the competitive landscape for our active study.
- User Asks: "Briefly describe the study NCT04988555 and find studies similar to it."
- What the Agent Does: The system performs a semantic search across a knowledge bank of study protocols. It identifies studies with similar designs, populations, and interventions, returning a concise summary of the competitive environment.

## Use Case 2: Promote Sites for Diverse Enrollment
- Goal: Find promising sites and prioritize those in underserved communities to improve trial diversity.
- User Asks: "List the U.S. clinical sites from these similar studies and prioritize them for underserved communities."
- What the Agent Does: The agent queries historical site performance data, cross-references it with socioeconomic data from the Social Determinants of Health Solution, and returns a ranked list that helps teams meet their diversity enrollment goals.

## Use Case 3: Identify and Evaluate Key Investigators
- Goal: Vet a top investigator and prepare for outreach.
- User Asks: "Draft an alignment report on Dr. Edward Garon (NPI: 1134153745) as a principal investigator for the study NCT04928846."
- What the Agent Does: The agent queries the CMS OpenPayment database for the PI's research grant history and trial experience. It then synthesizes this information into a report and evaluates their availability for review.


