This Solution requires a project setup to function correctly. 

![solution-frontpage.png](5Zz8HdmeuHfY)

# Connection configuration
Users should select the connections for the project datasets and the models driving the agents. The agentic system requires an SQL connection for its SQL query tool, a stronger model for planning and reasoning, a simpler model for basic tasks, and an embedding model for vectorization tasks. 
![projectsetup-connection.png](l1HpdjkGKsWO)

 **The following connections were tested on this Solution** :
- SQL connections: PostgreSQL, Amazon Redshift, Snowflake, Google BigQuery
- Completion models: gpt-4o, 4.1, 5 (OpenAI), claud 3.5, 3.7, 4 (Anthropic), gemini 2.5-flash, pro (Google)
- Embedding models: embedding v3 (OpenAI)

<div class="alert">
⚠️  Users might need to adjust the chunk size in the embedding recipe [compute_study_embedded](recipe:compute_study_embedded) according to the selected embedding models other than those tested above.
</div> 



# Import Solution insights (optional)
Select the project or the Dataiku application instance for the Clinical Site Intelligence Solution and Social Determinants of Health Solution, then select the required dataset for each input.
![projectsetup-import-solutions.png](KD210GdDPtmL)

<div class="alert">
⚠️  The Solution is prepackaged with 20k cancer studies and the US socioeconomic metrics. Users can opt out and run the agent with the prepackaged data as a trial. However, we highly encourage our users to carefully review this agentic framework, including its architecture and prompts, revise the framework as needed, and thoroughly test its output before implementation.
</div> 


# Build the pipeline
Click on the "Build Flow" button to create the pipeline.

# Additional Configuration
## Email Connection 
The agent requires an STMP channel. Users can create the channel in  **Administration**  >  **Notifications & Integrations**  >   **Salesforce login with Username-Password** >  **Messaging channels** >**Mail (SMTP) channel**. 

To generate a  **password**  to sign in within the Mail (SMTP) channel, use this [link](https://support.google.com/mail/answer/185833?hl=en). 

## Send message tool config
Select the corresponding mail channel for the agent tool [Sent Draft by Email](agent_tool:rTWyMmL)

# Launch Agent Hub
Once the pipeline is built, click the "Clinical Trial Intelligence Assistant" button to access the web app and interact with the agent.
![projectsetup-launch-agent-hub.png](Z3OwPICh4aAn)